/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.logging.aeri.core;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Send Options</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.ISendOptions#getComment <em>Comment</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.ISendOptions#getSeverity <em>Severity</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.ISendOptions#getEnabledProcessors <em>Enabled Processors</em>}</li>
 * </ul>
 *
 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getSendOptions()
 * @model
 * @generated
 */
public interface ISendOptions extends IUserSettings {
	/**
	 * Returns the value of the '<em><b>Comment</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Comment</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Comment</em>' attribute.
	 * @see #setComment(String)
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getSendOptions_Comment()
	 * @model
	 * @generated
	 */
	String getComment();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.logging.aeri.core.ISendOptions#getComment <em>Comment</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Comment</em>' attribute.
	 * @see #getComment()
	 * @generated
	 */
	void setComment(String value);

	/**
	 * Returns the value of the '<em><b>Severity</b></em>' attribute.
	 * The literals are from the enumeration {@link org.eclipse.epp.logging.aeri.core.Severity}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Severity</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Severity</em>' attribute.
	 * @see org.eclipse.epp.logging.aeri.core.Severity
	 * @see #setSeverity(Severity)
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getSendOptions_Severity()
	 * @model
	 * @generated
	 */
	Severity getSeverity();

	/**
	 * Sets the value of the '{@link org.eclipse.epp.logging.aeri.core.ISendOptions#getSeverity <em>Severity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Severity</em>' attribute.
	 * @see org.eclipse.epp.logging.aeri.core.Severity
	 * @see #getSeverity()
	 * @generated
	 */
	void setSeverity(Severity value);

	/**
	 * Returns the value of the '<em><b>Enabled Processors</b></em>' attribute list.
	 * The list contents are of type {@link org.eclipse.epp.logging.aeri.core.IReportProcessor}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Enabled Processors</em>' attribute list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Enabled Processors</em>' attribute list.
	 * @see org.eclipse.epp.logging.aeri.core.IModelPackage#getSendOptions_EnabledProcessors()
	 * @model dataType="org.eclipse.epp.logging.aeri.core.IReportProcessor"
	 * @generated
	 */
	EList<IReportProcessor> getEnabledProcessors();

} // ISendOptions
