/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.util.declaration;

import org.eclipse.wst.css.core.internal.contentmodel.PropCMProperty;
import org.eclipse.wst.css.core.internal.parserz.CSSTextParser;
import org.eclipse.wst.css.core.internal.parserz.CSSTextToken;
import org.eclipse.wst.css.core.internal.util.CSSUtil;
import org.eclipse.wst.css.core.internal.util.declaration.CSSPropertyContext;
import org.eclipse.wst.css.core.internal.util.declaration.IShorthandAdapter;

public class BackgroundShorthandAdapter
implements IShorthandAdapter {
    @Override
    public boolean expand(String source, CSSPropertyContext dest) {
        CSSTextParser parser = new CSSTextParser(2, source);
        CSSTextToken[] tokens = parser.getTokens();
        if (tokens.length <= 0) {
            return false;
        }
        String color = "";
        String image = "";
        String repeat = "";
        String attach = "";
        String pos = "";
        PropCMProperty propColor = PropCMProperty.getInstanceOf("background-color");
        PropCMProperty propImage = PropCMProperty.getInstanceOf("background-image");
        PropCMProperty propRepeat = PropCMProperty.getInstanceOf("background-repeat");
        PropCMProperty propAttach = PropCMProperty.getInstanceOf("background-attachment");
        PropCMProperty propPos = PropCMProperty.getInstanceOf("background-position");
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i].kind == "DECLARATION_VALUE_IDENT") {
                if (propColor.canHave(tokens[i].image)) {
                    color = tokens[i].image;
                } else if (propImage.canHave(tokens[i].image)) {
                    image = tokens[i].image;
                } else if (propRepeat.canHave(tokens[i].image)) {
                    repeat = tokens[i].image;
                } else if (propAttach.canHave(tokens[i].image)) {
                    attach = tokens[i].image;
                } else if (propPos.canHave(tokens[i].image)) {
                    pos = pos == null || pos.length() <= 0 ? tokens[i].image : String.valueOf(pos) + " " + tokens[i].image;
                }
            } else if (CSSUtil.isLength(tokens[i]) || tokens[i].kind == "DECLARATION_VALUE_NUMBER" || tokens[i].kind == "DECLARATION_VALUE_PERCENTAGE") {
                pos = pos == null || pos.length() <= 0 ? tokens[i].image : String.valueOf(pos) + " " + tokens[i].image;
            } else if (tokens[i].kind == "DECLARATION_VALUE_URI") {
                image = tokens[i].image;
            } else if (tokens[i].kind == "DECLARATION_VALUE_HASH") {
                color = tokens[i].image;
            } else if (tokens[i].kind == "DECLARATION_VALUE_FUNCTION") {
                StringBuffer buf = new StringBuffer();
                while (i < tokens.length) {
                    if (tokens[i].kind == "COMMENT") {
                        ++i;
                        continue;
                    }
                    buf.append(tokens[i].image);
                    if (tokens[i++].kind == "DECLARATION_VALUE_PARENTHESIS_CLOSE") break;
                }
                --i;
                color = buf.toString();
            }
            ++i;
        }
        dest.set(propColor.getName(), color);
        dest.set(propImage.getName(), image);
        dest.set(propRepeat.getName(), repeat);
        dest.set(propAttach.getName(), attach);
        dest.set(propPos.getName(), pos);
        return true;
    }

    @Override
    public String extract(String source, PropCMProperty propDest) {
        CSSTextParser parser = new CSSTextParser(2, source);
        CSSTextToken[] tokens = parser.getTokens();
        if (tokens.length <= 0) {
            return null;
        }
        String color = null;
        String image = null;
        String repeat = null;
        String attach = null;
        String pos = null;
        PropCMProperty propColor = PropCMProperty.getInstanceOf("background-color");
        PropCMProperty propImage = PropCMProperty.getInstanceOf("background-image");
        PropCMProperty propRepeat = PropCMProperty.getInstanceOf("background-repeat");
        PropCMProperty propAttach = PropCMProperty.getInstanceOf("background-attachment");
        PropCMProperty propPos = PropCMProperty.getInstanceOf("background-position");
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i].kind == "DECLARATION_VALUE_IDENT") {
                if (propColor.canHave(tokens[i].image)) {
                    color = tokens[i].image;
                } else if (propImage.canHave(tokens[i].image)) {
                    image = tokens[i].image;
                } else if (propRepeat.canHave(tokens[i].image)) {
                    repeat = tokens[i].image;
                } else if (propAttach.canHave(tokens[i].image)) {
                    attach = tokens[i].image;
                } else if (propPos.canHave(tokens[i].image)) {
                    pos = pos == null ? tokens[i].image : String.valueOf(pos) + " " + tokens[i].image;
                }
            } else if (CSSUtil.isLength(tokens[i]) || tokens[i].kind == "DECLARATION_VALUE_NUMBER" || tokens[i].kind == "DECLARATION_VALUE_PERCENTAGE") {
                pos = pos == null ? tokens[i].image : String.valueOf(pos) + " " + tokens[i].image;
            } else if (tokens[i].kind == "DECLARATION_VALUE_URI") {
                image = tokens[i].image;
            } else if (tokens[i].kind == "DECLARATION_VALUE_HASH") {
                color = tokens[i].image;
            } else if (tokens[i].kind == "DECLARATION_VALUE_FUNCTION") {
                StringBuffer buf = new StringBuffer();
                while (i < tokens.length) {
                    if (tokens[i].kind == "COMMENT") {
                        ++i;
                        continue;
                    }
                    buf.append(tokens[i].image);
                    if (tokens[i++].kind == "DECLARATION_VALUE_PARENTHESIS_CLOSE") break;
                }
                --i;
                color = buf.toString();
            }
            ++i;
        }
        if (propColor == propDest) {
            return color;
        }
        if (propImage == propDest) {
            return image;
        }
        if (propRepeat == propDest) {
            return repeat;
        }
        if (propAttach == propDest) {
            return attach;
        }
        if (propPos == propDest) {
            return pos;
        }
        return null;
    }
}

