/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.document;

import org.eclipse.wst.css.core.internal.document.CSSAttrImpl;
import org.eclipse.wst.css.core.internal.document.CSSNamedNodeMapImpl;
import org.eclipse.wst.css.core.internal.document.CSSNodeListImpl;
import org.eclipse.wst.css.core.internal.document.CSSRegionContainer;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.stylesheets.MediaList;

class MediaListImpl
extends CSSRegionContainer
implements MediaList {
    int mediumCounter;

    MediaListImpl() {
    }

    MediaListImpl(MediaListImpl that) {
        super(that);
    }

    @Override
    public void appendMedium(String newMedium) throws DOMException {
        if (newMedium == null) {
            return;
        }
        CSSNodeListImpl m = this.getMedia();
        int i = 0;
        while (i != m.getLength()) {
            if (newMedium.equals(this.item(i))) {
                return;
            }
            ++i;
        }
        this.setAttribute("medium" + Integer.toString(this.mediumCounter++), newMedium);
    }

    @Override
    public ICSSNode cloneNode(boolean deep) {
        MediaListImpl cloned = new MediaListImpl(this);
        return cloned;
    }

    @Override
    public void deleteMedium(String oldMedium) throws DOMException {
        int i = 0;
        while (i != this.getLength()) {
            if (oldMedium.equals(this.item(i))) {
                this.removeAttributeNode((CSSAttrImpl)this.fAttrs.item(i));
            }
            ++i;
        }
    }

    @Override
    public int getLength() {
        return this.getMedia().getLength();
    }

    CSSNodeListImpl getMedia() {
        if (this.fAttrs == null) {
            this.fAttrs = new CSSNamedNodeMapImpl();
        }
        return this.fAttrs;
    }

    @Override
    public String getMediaText() {
        return this.getCssText();
    }

    @Override
    public short getNodeType() {
        return 12;
    }

    @Override
    public String item(int index) {
        if (index < 0 || this.getLength() <= index) {
            return null;
        }
        return ((CSSAttrImpl)this.getMedia().item(index)).getValue();
    }

    @Override
    public void setMediaText(String mediaText) throws DOMException {
        this.setCssText(mediaText);
    }
}

