/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xycharts;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.xycharts.TmfXyUiUtils;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.ITmfChartTimeProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfBaseProvider;
import org.swtchart.Chart;

public class TmfMouseWheelZoomProvider
extends TmfBaseProvider
implements MouseWheelListener {
    public TmfMouseWheelZoomProvider(ITmfChartTimeProvider tmfChartViewer) {
        super(tmfChartViewer);
        this.register();
    }

    @Override
    public void register() {
        this.getChart().getPlotArea().addMouseWheelListener((MouseWheelListener)this);
    }

    @Override
    public void deregister() {
        if (this.getChartViewer().getControl() != null && !this.getChartViewer().getControl().isDisposed()) {
            this.getChart().getPlotArea().removeMouseWheelListener((MouseWheelListener)this);
        }
    }

    @Override
    public void refresh() {
    }

    public synchronized void mouseScrolled(MouseEvent event) {
        int count = event.count;
        if ((event.stateMask & 0x40000) != 0) {
            int x = event.x;
            this.zoom(count, x);
        } else if ((event.stateMask & 0x20000) != 0) {
            this.scroll(count);
        }
    }

    private void scroll(int count) {
        ITmfChartTimeProvider viewer = this.getChartViewer();
        Chart chart = this.getChart();
        if (viewer != null && chart != null && count != 0) {
            TmfXyUiUtils.horizontalScroll(viewer, chart, count > 0);
        }
    }

    private void zoom(int count, int x) {
        ITmfChartTimeProvider viewer = this.getChartViewer();
        Chart chart = this.getChart();
        if (viewer != null && chart != null && count != 0) {
            TmfXyUiUtils.zoom(viewer, chart, count > 0, x);
        }
    }
}

