/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.ui.widgets.timegraph;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.provisional.tmf.ui.widgets.timegraph.IStylePresentationProvider;
import org.eclipse.tracecompass.tmf.core.model.IOutputStyleProvider;
import org.eclipse.tracecompass.tmf.core.model.ITimeElement;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.OutputStyleModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.ui.colors.ColorUtils;
import org.eclipse.tracecompass.tmf.ui.model.StyleManager;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class BaseDataProviderTimeGraphPresentationProvider
extends TimeGraphPresentationProvider
implements IStylePresentationProvider {
    private static final OutputElementStyle TRANSPARENT_STYLE = new OutputElementStyle(null, (Map)ImmutableMap.of());
    private final Map<ITimeGraphDataProvider<?>, BiFunction<ITimeEvent, Long, Map<String, String>>> fProviders = new LinkedHashMap();
    private boolean fShowTooltipTimes = true;
    private Map<String, Integer> fKeyToIndex = new HashMap<String, Integer>();
    private @Nullable Map<String, OutputElementStyle> fStylesMap = null;
    private @Nullable StateItem @Nullable [] fStateTable = null;
    private StyleManager fStyleManager = new StyleManager(this.fetchStyles());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProvider(ITimeGraphDataProvider<?> provider, BiFunction<ITimeEvent, Long, Map<String, String>> tooltipResolver) {
        Map<ITimeGraphDataProvider<?>, BiFunction<ITimeEvent, Long, Map<String, String>>> map = this.fProviders;
        synchronized (map) {
            this.fProviders.put(provider, tooltipResolver);
        }
        Display.getDefault().asyncExec(() -> this.refresh());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<@NonNull String, @NonNull OutputElementStyle> fetchStyles() {
        Map<String, OutputElementStyle> stylesMap = this.fStylesMap;
        if (stylesMap == null) {
            stylesMap = new LinkedHashMap<String, OutputElementStyle>();
            Map<ITimeGraphDataProvider<?>, BiFunction<ITimeEvent, Long, Map<String, String>>> map = this.fProviders;
            synchronized (map) {
                for (ITimeGraphDataProvider<?> provider : this.fProviders.keySet()) {
                    TmfModelResponse styleResponse;
                    OutputStyleModel styleModel;
                    if (!(provider instanceof IOutputStyleProvider) || (styleModel = (OutputStyleModel)(styleResponse = ((IOutputStyleProvider)provider).fetchStyle(this.getStyleParameters(), null)).getModel()) == null) continue;
                    for (Map.Entry entry : styleModel.getStyles().entrySet()) {
                        OutputElementStyle style = (OutputElementStyle)entry.getValue();
                        stylesMap.put((String)entry.getKey(), new OutputElementStyle(style.getParentKey(), (Map)Maps.newHashMap((Map)style.getStyleValues())));
                    }
                }
            }
            this.fStylesMap = stylesMap;
        }
        return stylesMap;
    }

    protected Map<String, Object> getStyleParameters() {
        return Collections.emptyMap();
    }

    @Override
    public StateItem[] getStateTable() {
        @Nullable StateItem[] stateTable = this.fStateTable;
        if (stateTable == null) {
            Map<@NonNull String, @NonNull OutputElementStyle> styles = this.fetchStyles();
            if (styles.isEmpty()) {
                stateTable = new StateItem[]{};
                this.fStateTable = stateTable;
                return stateTable;
            }
            ArrayList<StateItem> stateItemList = new ArrayList<StateItem>();
            int tableIndex = 0;
            for (Map.Entry<String, OutputElementStyle> styleEntry : styles.entrySet()) {
                Object styleGroup;
                Object symbolType;
                String styleKey = styleEntry.getKey();
                this.fKeyToIndex.put(styleKey, tableIndex++);
                OutputElementStyle elementStyle = styleEntry.getValue();
                HashMap<String, Object> styleMap = new HashMap<String, Object>();
                RGBAColor rgba = this.getColorStyle(elementStyle, "background-color");
                RGB rgb = rgba != null ? new RGB((int)rgba.getRed(), (int)rgba.getGreen(), (int)rgba.getBlue()) : new RGB(0, 0, 0);
                styleMap.put("background-color", ColorUtils.toHexColor(rgb));
                Object styleName = this.getStyle(elementStyle, "style-name");
                if (styleName instanceof String) {
                    styleMap.put("style-name", styleName);
                } else {
                    styleMap.put("style-name", styleEntry.getKey());
                }
                Float height = this.getFloatStyle(elementStyle, "height");
                if (height != null) {
                    styleMap.put("height", height);
                }
                if ((symbolType = this.getStyle(elementStyle, "symbol-type")) instanceof String) {
                    styleMap.put("symbol-type", symbolType);
                }
                if ((styleGroup = this.getStyle(elementStyle, "style-group")) != null) {
                    styleMap.put("style-group", styleGroup);
                }
                stateItemList.add(new StateItem(styleMap));
            }
            stateTable = stateItemList.toArray(new StateItem[stateItemList.size()]);
            this.fStateTable = stateTable;
        }
        return stateTable;
    }

    @Override
    @Deprecated
    public int getStateTableIndex(@Nullable ITimeEvent event) {
        return -1;
    }

    @Override
    @NonNullByDefault(value={})
    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event) {
        return this.getEventHoverToolTipInfo(event, event.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNullByDefault(value={})
    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event, long hoverTime) {
        if (event != null && !(event instanceof NullTimeEvent)) {
            LinkedHashMap<String, String> tooltipInfo = new LinkedHashMap<String, String>();
            Map<ITimeGraphDataProvider<?>, BiFunction<ITimeEvent, Long, Map<String, String>>> map = this.fProviders;
            synchronized (map) {
                this.fProviders.values().forEach(tooltipResolver -> tooltipInfo.putAll((Map)tooltipResolver.apply(event, hoverTime)));
            }
            return tooltipInfo;
        }
        return Collections.emptyMap();
    }

    @Override
    public @Nullable OutputElementStyle getElementStyle(ITimeEvent event) {
        if (event instanceof NullTimeEvent) {
            return null;
        }
        if (event instanceof TimeEvent) {
            ITimeElement model = ((TimeEvent)event).getModel();
            OutputElementStyle eventStyle = model.getStyle();
            if (eventStyle == null && event.getEntry() instanceof TimeGraphEntry) {
                eventStyle = ((TimeGraphEntry)event.getEntry()).getEntryModel().getStyle();
            }
            if (eventStyle != null) {
                return eventStyle;
            }
        }
        return TRANSPARENT_STYLE;
    }

    @Override
    public @NonNull StyleManager getStyleManager() {
        return this.fStyleManager;
    }

    @Override
    public @Nullable Object getStyle(OutputElementStyle elementStyle, String property) {
        return this.fStyleManager.getStyle(elementStyle, property);
    }

    @Override
    public @Nullable Float getFloatStyle(OutputElementStyle elementStyle, String property) {
        return this.fStyleManager.getFactorStyle(elementStyle, property);
    }

    @Override
    public @Nullable RGBAColor getColorStyle(OutputElementStyle elementStyle, String property) {
        return this.fStyleManager.getColorStyle(elementStyle, property);
    }

    @Override
    public void refresh() {
        this.fStylesMap = null;
        this.fStateTable = null;
        this.fStyleManager = new StyleManager(this.fetchStyles());
        super.refresh();
        this.updateStyles();
    }

    @Override
    public boolean displayTimesInTooltip() {
        return this.fShowTooltipTimes;
    }

    public void setShowTimesInTooltip(boolean showTimes) {
        this.fShowTooltipTimes = showTimes;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void updateStyles() {
        Map<String, OutputElementStyle> stylesMap = this.fStylesMap;
        StateItem[] stateTable = this.fStateTable;
        if (stylesMap == null || stateTable == null) {
            return;
        }
        for (Map.Entry<String, Integer> entry : this.fKeyToIndex.entrySet()) {
            OutputElementStyle elementStyle = stylesMap.get(entry.getKey());
            Integer index = entry.getValue();
            if (elementStyle == null || index >= stateTable.length) continue;
            StateItem stateItem = stateTable[index];
            RGB rgb = stateItem.getStateColor();
            @NonNull @NonNull Map styleValues = elementStyle.getStyleValues();
            RGBAColor rgba = this.getColorStyle(elementStyle, "background-color");
            if (rgba == null || !new RGB((int)rgba.getRed(), (int)rgba.getGreen(), (int)rgba.getBlue()).equals((Object)rgb)) {
                String hexColor = ColorUtils.toHexColor(rgb);
                styleValues.put("background-color", hexColor);
                styleValues.put("color", hexColor);
                styleValues.put("opacity", Float.valueOf(1.0f));
            }
            float heightFactor = stateItem.getStateHeightFactor();
            Float prevHeightFactor = this.getFloatStyle(elementStyle, "height");
            if (Float.valueOf(heightFactor).equals(prevHeightFactor)) continue;
            if (prevHeightFactor == null) {
                styleValues.put("height", Float.valueOf(heightFactor));
                continue;
            }
            Float height = elementStyle.getStyleValues().getOrDefault("height", Float.valueOf(1.0f));
            height = height instanceof Float ? height : Float.valueOf(1.0f);
            styleValues.put("height", Float.valueOf(height.floatValue() * heightFactor / prevHeightFactor.floatValue()));
        }
    }
}

