/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.proxy.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class StringTable {
    private final Map<String, StringEntry> fMap = new HashMap<String, StringEntry>();
    private final ArrayList<StringEntry> fList = new ArrayList();

    public void flush() {
        this.fMap.clear();
        this.fList.clear();
    }

    public String get(int index) throws IndexOutOfBoundsException {
        StringEntry entry = this.fList.get(index - 1);
        return entry.getEntry();
    }

    public int get(String str) throws NoSuchElementException {
        StringEntry entry = this.fMap.get(str);
        if (entry == null) {
            throw new NoSuchElementException(str);
        }
        return entry.getIndex();
    }

    public int put(String str) {
        StringEntry entry = this.fMap.get(str);
        if (entry == null) {
            entry = new StringEntry(str, this.fList.size());
            this.fMap.put(str, entry);
            this.fList.add(entry);
            return -entry.getIndex();
        }
        return entry.getIndex();
    }

    public int size() {
        return this.fList.size();
    }

    private class StringEntry {
        private final String fEntry;
        private final int fIndex;

        public StringEntry(String str, int index) {
            this.fEntry = str;
            this.fIndex = index + 1;
        }

        public String getEntry() {
            return this.fEntry;
        }

        public int getIndex() {
            return this.fIndex;
        }
    }
}

