/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.ui.pages;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.IDebugEditorPresentation;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugModelPresentationExtension;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.ocl.examples.debug.vm.core.VMDebugTarget;
import org.eclipse.ocl.examples.debug.vm.core.VMLineBreakpoint;
import org.eclipse.ocl.examples.debug.vm.core.VMStackFrame;
import org.eclipse.ocl.examples.debug.vm.core.VMThread;
import org.eclipse.ocl.examples.debug.vm.core.VMValue;
import org.eclipse.ocl.examples.debug.vm.core.VMVariable;
import org.eclipse.ocl.examples.debug.vm.data.VMLocationData;
import org.eclipse.ocl.examples.debug.vm.ui.DebugVMUIPlugin;
import org.eclipse.ocl.examples.debug.vm.ui.actions.DebugVMImages;
import org.eclipse.ocl.examples.debug.vm.ui.messages.DebugVMUIMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.ui.editor.XtextReadonlyEditorInput;

public abstract class VMDebugModelPresentation
implements IDebugModelPresentation,
IDebugEditorPresentation,
IDebugModelPresentationExtension,
IColorProvider,
ILabelProvider {
    public void setAttribute(String attribute, Object value) {
    }

    public Image getImage(Object element) {
        if (element instanceof VMDebugTarget) {
            return DebugVMImages.getImage("ExpressionInOCL");
        }
        if (element instanceof VMThread) {
            return null;
        }
        if (element instanceof VMStackFrame) {
            return null;
        }
        if (element instanceof VMVariable) {
            VMVariable var = (VMVariable)element;
            if (var.isModelParameter()) {
                return DebugVMImages.getImage("modelParameter");
            }
            if (var.isReference()) {
                return DebugVMImages.getImage("reference");
            }
            if (var.isAttribute()) {
                return DebugVMImages.getImage("attribute");
            }
            if (var.isIntermProperty()) {
                return DebugVMImages.getImage("intermediateProperty");
            }
            if (var.isLocalVariable()) {
                return DebugVMImages.getImage("localVariable");
            }
            if (var.isPredefinedVariable()) {
                try {
                    if ("this".equals(var.getName())) {
                        return DebugVMImages.getImage("thisVariable");
                    }
                }
                catch (DebugException debugException) {
                    // empty catch block
                }
                return DebugVMImages.getImage("predefinedVariable");
            }
            if (var.isCollectionElement()) {
                return DebugVMImages.getImage("collectionElement");
            }
        } else if (element instanceof VMLineBreakpoint) {
            VMLineBreakpoint breakpoint = (VMLineBreakpoint)element;
            try {
                if (breakpoint.isConditionEnabled()) {
                    return breakpoint.isEnabled() ? DebugVMImages.getImage("conditionalBreakpointEnabled") : DebugVMImages.getImage("conditionalBreakpointDisabled");
                }
            }
            catch (CoreException ex) {
                DebugVMUIPlugin.log(ex);
            }
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof VMDebugTarget) {
            VMDebugTarget debugTarget = (VMDebugTarget)element;
            String moduleName = debugTarget.getMainModuleName();
            String launchConfigName = debugTarget.getLaunch().getLaunchConfiguration().getName();
            return NLS.bind((String)DebugVMUIMessages.DebugModelPresentation_ExpressionInOCLLabel, (Object)moduleName, (Object)launchConfigName);
        }
        if (element instanceof VMThread) {
            VMThread thread = (VMThread)element;
            String name = "main";
            String state = thread.isSuspended() ? DebugVMUIMessages.DebugModelPresentation_Suspended : DebugVMUIMessages.DebugModelPresentation_Running;
            return MessageFormat.format(DebugVMUIMessages.DebugModelPresentation_ThreadLabel, name, state);
        }
        if (element instanceof VMStackFrame) {
            VMStackFrame frame = (VMStackFrame)element;
            VMLocationData location = frame.getLocation();
            int line = frame.getLineNumber();
            StringBuilder s = new StringBuilder();
            String elementSignature = location.getElementSignature();
            if (elementSignature != null) {
                s.append(elementSignature);
                s.append(" - ");
            }
            s.append(location.getModule());
            s.append(" line: ");
            s.append(line);
            return s.toString();
        }
        return null;
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        if (value instanceof VMValue) {
            VMValue vmValue = (VMValue)value;
            try {
                listener.detailComputed(value, vmValue.computeDetail());
            }
            catch (DebugException e) {
                DebugVMUIPlugin.log(e.getStatus());
            }
        } else {
            listener.detailComputed(value, value.toString());
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public IEditorInput getEditorInput(Object element) {
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof ILineBreakpoint) {
            return new FileEditorInput((IFile)((ILineBreakpoint)element).getMarker().getResource());
        }
        if (element instanceof IStorage) {
            return new XtextReadonlyEditorInput((IStorage)element);
        }
        return null;
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public boolean addAnnotations(IEditorPart editorPart, IStackFrame frame) {
        return false;
    }

    public void removeAnnotations(IEditorPart editorPart, IThread thread) {
    }

    public void dispose() {
    }

    public boolean requiresUIThread(Object element) {
        return true;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

