/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml.internal.dialogs;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.ui.internal.components.PomHierarchyComposite;
import org.eclipse.m2e.core.ui.internal.dialogs.AbstractMavenDialog;
import org.eclipse.m2e.core.ui.internal.util.ParentHierarchyEntry;
import org.eclipse.m2e.editor.xml.internal.Messages;
import org.eclipse.m2e.editor.xml.internal.dialogs.SPDXLicense;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class SelectSPDXLicenseDialog
extends AbstractMavenDialog {
    IMavenProjectFacade targetProject;
    SPDXLicense license;
    final IMavenProjectFacade project;
    static final IStatus STATUS_NO_LICENSE_SELECTION = new Status(4, "org.eclipse.m2e.editor.xml", Messages.SelectSPDXLicenseDialog_noLicenseSelected_status);
    static final IStatus STATUS_NO_WORKSPACE_POM_SELECTION = new Status(4, "org.eclipse.m2e.editor.xml", Messages.SelectSPDXLicenseDialog_noWorkspacePomSelected_status);

    public SelectSPDXLicenseDialog(Shell parentShell, IMavenProjectFacade project) {
        super(parentShell, SelectSPDXLicenseDialog.class.getName());
        this.setStatusLineAboveButtons(true);
        this.setTitle(Messages.SelectSPDXLicenseDialog_Title);
        this.project = project;
        this.targetProject = project;
        this.updateStatus(STATUS_NO_LICENSE_SELECTION);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Label lblLicenseNameFilter = new Label(container, 0);
        lblLicenseNameFilter.setText(Messages.SelectSPDXLicenseDialog_lblLicenseNameFilter_text);
        Text licenseFilter = new Text(container, 2176);
        licenseFilter.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblLicenses = new Label(container, 0);
        lblLicenses.setText(Messages.SelectSPDXLicenseDialog_lblLicenses_text);
        TableViewer licensesViewer = new TableViewer(container, 67584);
        Table licensesTable = licensesViewer.getTable();
        licensesTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                SelectSPDXLicenseDialog.this.handleDoubleClick();
            }
        });
        licensesTable.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            ISelection selection = licensesViewer.getSelection();
            this.license = selection instanceof IStructuredSelection && !selection.isEmpty() ? (SPDXLicense)((IStructuredSelection)selection).getFirstElement() : null;
            this.updateStatus();
        }));
        GridData gd_licensesTable = new GridData(4, 4, true, true, 1, 1);
        gd_licensesTable.heightHint = 400;
        licensesTable.setLayoutData((Object)gd_licensesTable);
        licensesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return null;
            }
        });
        licensesViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getText(Object element) {
                if (element instanceof SPDXLicense) {
                    return ((SPDXLicense)element).getName();
                }
                return null;
            }

            public Image getImage(Object element) {
                return null;
            }
        });
        licensesViewer.setInput(SPDXLicense.getStandardLicenses());
        licenseFilter.addModifyListener(e -> {
            String text2 = licenseFilter.getText();
            ViewerFilter[] filters = text2 != null && text2.trim().length() > 0 ? new ViewerFilter[]{new LicenseFilter(text2.trim())} : new ViewerFilter[]{};
            licensesViewer.setFilters(filters);
        });
        Label lblPomxml = new Label(container, 0);
        lblPomxml.setText(Messages.SelectSPDXLicenseDialog_lblPomxml_text);
        PomHierarchyComposite parentComposite = new PomHierarchyComposite(container, 0);
        parentComposite.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                SelectSPDXLicenseDialog.this.handleDoubleClick();
            }
        });
        parentComposite.addSelectionChangedListener(event -> {
            ISelection selection = parentComposite.getSelection();
            if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                ParentHierarchyEntry mavenProject = (ParentHierarchyEntry)((IStructuredSelection)selection).getFirstElement();
                this.targetProject = mavenProject.getFacade();
                this.updateStatus();
            }
        });
        parentComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        parentComposite.computeHeirarchy(this.project, null);
        parentComposite.setSelection((ISelection)new StructuredSelection(parentComposite.getHierarchy().get(0)));
        return container;
    }

    public SPDXLicense getLicense() {
        return this.license;
    }

    public IMavenProjectFacade getTargetProject() {
        return this.targetProject;
    }

    protected void computeResult() {
    }

    void updateStatus() {
        this.updateStatus(this.getStatus());
    }

    private IStatus getStatus() {
        IStatus status = this.license == null ? STATUS_NO_LICENSE_SELECTION : (this.targetProject == null ? STATUS_NO_WORKSPACE_POM_SELECTION : Status.OK_STATUS);
        return status;
    }

    void handleDoubleClick() {
        if (this.getStatus().isOK()) {
            this.okPressed();
        }
    }

    private static class LicenseFilter
    extends ViewerFilter {
        private final String text;

        public LicenseFilter(String text) {
            this.text = text.toLowerCase();
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof SPDXLicense) {
                return ((SPDXLicense)element).getName().toLowerCase().contains(this.text);
            }
            return false;
        }
    }
}

