/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.m2e.core.ui.internal.actions.OpenPomAction;
import org.eclipse.m2e.editor.xml.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLEditorUtility {
    private static final Logger log = LoggerFactory.getLogger(XMLEditorUtility.class);

    public static void openXmlEditor(IFileStore fileStore) {
        XMLEditorUtility.openXmlEditor(fileStore, -1, -1, fileStore.getName());
    }

    public static void openXmlEditor(IFileStore fileStore, int line, int column, String name) {
        IWorkbenchPage page;
        assert (fileStore != null);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            try {
                if (!fileStore.getName().endsWith(".pom")) {
                    IEditorPart part = IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                    XMLEditorUtility.reveal(XMLEditorUtility.selectEditorPage(part), line, column);
                } else {
                    name = String.valueOf(name) + ".pom";
                    File file = new File(fileStore.toURI());
                    try {
                        OpenPomAction.MavenPathStorageEditorInput input = new OpenPomAction.MavenPathStorageEditorInput(name, name, file.getAbsolutePath(), XMLEditorUtility.readStream(new FileInputStream(file)));
                        IEditorPart part = OpenPomAction.openEditor((IEditorInput)input, (String)name);
                        XMLEditorUtility.reveal(XMLEditorUtility.selectEditorPage(part), line, column);
                    }
                    catch (IOException e) {
                        log.error("failed opening editor", (Throwable)e);
                    }
                }
            }
            catch (PartInitException e) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.PomHyperlinkDetector_error_title, (String)NLS.bind((String)Messages.PomHyperlinkDetector_error_message, (Object)fileStore, (Object)e.toString()));
            }
        }
    }

    private static StructuredTextEditor selectEditorPage(IEditorPart part) {
        if (part == null) {
            return null;
        }
        if (part instanceof FormEditor) {
            FormEditor ed = (FormEditor)part;
            ed.setActivePage(null);
            if (ed.getActiveEditor() instanceof StructuredTextEditor) {
                return (StructuredTextEditor)ed.getActiveEditor();
            }
        }
        return null;
    }

    private static void reveal(StructuredTextEditor structured, int line, int column) {
        if (structured == null || line < 0 || column < 0) {
            return;
        }
        IDocument doc = structured.getTextViewer().getDocument();
        if (doc instanceof IStructuredDocument) {
            IStructuredDocument document = (IStructuredDocument)doc;
            try {
                int offset = document.getLineOffset(line - 1);
                structured.selectAndReveal(offset + column - 1, 0);
            }
            catch (BadLocationException e) {
                log.error("failed selecting part of editor", (Throwable)e);
            }
        }
    }

    private static byte[] readStream(InputStream is) throws IOException {
        byte[] b = new byte[is.available()];
        int len = 0;
        while (true) {
            byte[] c;
            int n;
            if ((n = is.read(b, len, b.length - len)) == -1) {
                if (len < b.length) {
                    c = new byte[len];
                    System.arraycopy(b, 0, c, 0, len);
                    b = c;
                }
                return b;
            }
            if ((len += n) != b.length) continue;
            c = new byte[b.length + 1000];
            System.arraycopy(b, 0, c, 0, len);
            b = c;
        }
    }
}

