/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.utils.IParamValueToken;
import org.eclipse.jubula.client.core.utils.IParamValueValidator;
import org.eclipse.jubula.client.core.utils.ParamValueConverter;

public class GuiParamValueConverter
extends ParamValueConverter {
    public GuiParamValueConverter(String guiString, IParameterInterfacePO currentNode, IParamDescriptionPO desc, IParamValueValidator validator) {
        super(currentNode, desc, validator);
        this.init(guiString);
    }

    protected GuiParamValueConverter() {
    }

    protected void init(String guiString) {
        this.setGuiString(guiString);
        this.createTokens();
    }

    @Override
    void validateSingleTokens() {
        for (IParamValueToken token : this.getTokens()) {
            ParamValueConverter.ConvValidationState state = token.validate();
            this.createTokenError(state, token);
        }
        if (!this.containsErrors()) {
            ParamValueConverter.ConvValidationState state = this.getValidator().validateInput(this.getTokens());
            for (IParamValueToken token : this.getTokens()) {
                Integer errorKey = token.getErrorKey();
                if (errorKey != null && state == ParamValueConverter.ConvValidationState.invalid) {
                    this.createTokenError(state, token);
                    return;
                }
                if (state != ParamValueConverter.ConvValidationState.undecided) continue;
                this.createTokenError(state, token);
            }
        }
    }

    public Set<String> getParametersToAdd(ISpecTestCasePO parent) {
        List<String> newRefs = this.getNamesForReferences();
        HashSet<String> refs = new HashSet<String>(newRefs);
        if (!refs.isEmpty()) {
            for (IParamDescriptionPO desc : parent.getParameterList()) {
                refs.remove(desc.getName());
            }
        }
        return refs;
    }

    @Override
    public String getModelString() {
        if (super.getModelString() == null) {
            StringBuilder builder = new StringBuilder();
            for (IParamValueToken token : this.getTokens()) {
                String modelString = token.getModelString();
                if (modelString == null) {
                    return null;
                }
                builder.append(token.getModelString());
            }
            this.setModelString(builder.toString());
        }
        return super.getModelString();
    }

    @Override
    public boolean isGUI() {
        return true;
    }
}

