/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.model.TDCell;
import org.eclipse.jubula.client.core.utils.ModelParamValueConverter;
import org.eclipse.jubula.client.core.utils.RefToken;

public class TreeOpsBP {
    private TreeOpsBP() {
    }

    public static IExecTestCasePO extractTestCase(String newTcName, INodePO ownerNode, List<INodePO> modNodes, EntityManager s, ParamNameBPDecorator mapper) {
        boolean isOwnerSpecTestCase = ownerNode instanceof ISpecTestCasePO;
        INodePO oldParent = modNodes.get(0).getParentNode();
        ISpecTestCasePO newTc = NodeMaker.createSpecTestCasePO(newTcName);
        newTc.setParentProjectId(oldParent.getParentProjectId());
        s.persist((Object)newTc);
        int pos = -1;
        HashMap<String, String> oldToNewParamGuids = new HashMap<String, String>();
        for (INodePO moveNode : modNodes) {
            if (isOwnerSpecTestCase && moveNode instanceof IParamNodePO) {
                TreeOpsBP.addParamsToParent(newTc, (IParamNodePO)moveNode, mapper, (ISpecTestCasePO)ownerNode, oldToNewParamGuids);
            }
            pos = oldParent.indexOf(moveNode);
            oldParent.removeNode(moveNode);
            newTc.addNode(moveNode);
        }
        IExecTestCasePO newExec = NodeMaker.createExecTestCasePO(newTc);
        newExec.setSpecTestCase(newTc);
        if (isOwnerSpecTestCase) {
            TreeOpsBP.propagateParams(newExec, (IParamNodePO)ownerNode);
        }
        TreeOpsBP.propagateCompNames(modNodes, newExec);
        oldParent.addNode(pos, newExec);
        s.persist((Object)newExec);
        ownerNode.addTrackedChange("modified", true);
        return newExec;
    }

    private static void addParamsToParent(ISpecTestCasePO parent, IParamNodePO child, IParamNameMapper mapper, ISpecTestCasePO ownerNode, Map<String, String> oldToNewUuids) {
        TDCell cell = null;
        Iterator<TDCell> it = child.getParamReferencesIterator();
        while (it.hasNext()) {
            cell = it.next();
            String guid = child.getDataManager().getUniqueIds().get(cell.getCol());
            IParamDescriptionPO childDesc = child.getParameterForUniqueId(guid);
            if (childDesc == null) continue;
            ModelParamValueConverter conv = new ModelParamValueConverter(cell.getTestData(), child, childDesc);
            List<RefToken> refTokens = conv.getRefTokens();
            for (RefToken refToken : refTokens) {
                String uiString = RefToken.extractCore(refToken.getGuiString());
                IParamDescriptionPO parentParamDescr = parent.addParameter(childDesc.getType(), uiString, false, mapper);
                List<IParamDescriptionPO> ownerDescs = ownerNode.getParameterList();
                String oldUuid = "";
                for (IParamDescriptionPO ownerDesc : ownerDescs) {
                    if (!ownerDesc.getName().equals(uiString)) continue;
                    oldUuid = ownerDesc.getUniqueId();
                    break;
                }
                if (parentParamDescr == null) continue;
                String newUuid = parentParamDescr.getUniqueId();
                oldToNewUuids.put(oldUuid, newUuid);
            }
            conv.replaceUuidsInReferences(oldToNewUuids);
            cell.setTestData(conv.getModelString());
        }
    }

    private static void propagateCompNames(List<INodePO> modNodes, IExecTestCasePO newExec) {
        for (INodePO modNode : modNodes) {
            if (!(modNode instanceof IExecTestCasePO)) continue;
            IExecTestCasePO execTc = (IExecTestCasePO)modNode;
            for (ICompNamesPairPO pair : execTc.getCompNamesPairs()) {
                if (!pair.isPropagated()) continue;
                String secondName = pair.getSecondName();
                ICompNamesPairPO newPairPO = PoMaker.createCompNamesPairPO(secondName, secondName, pair.getType());
                newPairPO.setPropagated(true);
                newExec.addCompNamesPair(newPairPO);
            }
        }
    }

    private static void propagateParams(IExecTestCasePO execTc, IParamNodePO ownerNode) {
        execTc.resolveTDReference();
        List<IParamDescriptionPO> parameterList = execTc.getParameterList();
        List<IParamDescriptionPO> ownerParamList = ownerNode.getParameterList();
        for (IParamDescriptionPO descr : parameterList) {
            StringBuilder builder = new StringBuilder();
            String paramName = descr.getName();
            for (IParamDescriptionPO ownerDesc : ownerParamList) {
                if (!ownerDesc.getName().equals(paramName)) continue;
                builder.append(ownerDesc.getUniqueId());
                break;
            }
            String value = String.valueOf('=') + builder.toString();
            execTc.getDataManager().updateCell(value, 0, descr.getUniqueId());
        }
    }

    private static INodePO findNode(INodePO ownerNode, INodePO selectecNode) {
        Iterator<INodePO> childIt = ownerNode.getNodeListIterator();
        while (childIt.hasNext()) {
            INodePO child = childIt.next();
            if (!child.getId().equals(selectecNode.getId())) continue;
            return child;
        }
        return null;
    }
}

