/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.dialogs;

import static org.eclipse.jface.dialogs.IDialogConstants.*;

import org.eclipse.epp.internal.logging.aeri.ide.l10n.Messages;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class SetupWizardDialog extends WizardDialog {
    private SetupWizard newWizard;

    public SetupWizardDialog(Shell parentShell, SetupWizard newWizard) {
        super(parentShell, newWizard);
        this.newWizard = newWizard;
        setHelpAvailable(false);
    }

    @Override
    protected void handleShellCloseEvent() {
        newWizard.notifyShellClosedEvent();
        super.handleShellCloseEvent();
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        getButton(CANCEL_ID).setText(Messages.BUTTON_TEXT_DISABLE);
        getButton(FINISH_ID).setText(Messages.BUTTON_TEXT_ENABLE);
    }
}
