/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.logging.aeri.core.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;

import org.eclipse.epp.logging.aeri.core.IModelPackage;
import org.eclipse.epp.logging.aeri.core.IProblemState;
import org.eclipse.epp.logging.aeri.core.ProblemStatus;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Problem State</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.ProblemStateImpl#getStatus <em>Status</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.ProblemStateImpl#getMessage <em>Message</em>}</li>
 *   <li>{@link org.eclipse.epp.logging.aeri.core.impl.ProblemStateImpl#getNeedinfo <em>Needinfo</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ProblemStateImpl extends LinkableImpl implements IProblemState {
	/**
	 * The default value of the '{@link #getStatus() <em>Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStatus()
	 * @generated
	 * @ordered
	 */
	protected static final ProblemStatus STATUS_EDEFAULT = ProblemStatus.NEW;

	/**
	 * The cached value of the '{@link #getStatus() <em>Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStatus()
	 * @generated
	 * @ordered
	 */
	protected ProblemStatus status = STATUS_EDEFAULT;

	/**
	 * The default value of the '{@link #getMessage() <em>Message</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMessage()
	 * @generated
	 * @ordered
	 */
	protected static final String MESSAGE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getMessage() <em>Message</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMessage()
	 * @generated
	 * @ordered
	 */
	protected String message = MESSAGE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getNeedinfo() <em>Needinfo</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNeedinfo()
	 * @generated
	 * @ordered
	 */
	protected EList<String> needinfo;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProblemStateImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return IModelPackage.Literals.PROBLEM_STATE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProblemStatus getStatus() {
		return status;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStatus(ProblemStatus newStatus) {
		ProblemStatus oldStatus = status;
		status = newStatus == null ? STATUS_EDEFAULT : newStatus;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IModelPackage.PROBLEM_STATE__STATUS, oldStatus, status));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getMessage() {
		return message;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMessage(String newMessage) {
		String oldMessage = message;
		message = newMessage;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, IModelPackage.PROBLEM_STATE__MESSAGE, oldMessage, message));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<String> getNeedinfo() {
		if (needinfo == null) {
			needinfo = new EDataTypeUniqueEList<String>(String.class, this, IModelPackage.PROBLEM_STATE__NEEDINFO);
		}
		return needinfo;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case IModelPackage.PROBLEM_STATE__STATUS:
				return getStatus();
			case IModelPackage.PROBLEM_STATE__MESSAGE:
				return getMessage();
			case IModelPackage.PROBLEM_STATE__NEEDINFO:
				return getNeedinfo();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case IModelPackage.PROBLEM_STATE__STATUS:
				setStatus((ProblemStatus)newValue);
				return;
			case IModelPackage.PROBLEM_STATE__MESSAGE:
				setMessage((String)newValue);
				return;
			case IModelPackage.PROBLEM_STATE__NEEDINFO:
				getNeedinfo().clear();
				getNeedinfo().addAll((Collection<? extends String>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case IModelPackage.PROBLEM_STATE__STATUS:
				setStatus(STATUS_EDEFAULT);
				return;
			case IModelPackage.PROBLEM_STATE__MESSAGE:
				setMessage(MESSAGE_EDEFAULT);
				return;
			case IModelPackage.PROBLEM_STATE__NEEDINFO:
				getNeedinfo().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case IModelPackage.PROBLEM_STATE__STATUS:
				return status != STATUS_EDEFAULT;
			case IModelPackage.PROBLEM_STATE__MESSAGE:
				return MESSAGE_EDEFAULT == null ? message != null : !MESSAGE_EDEFAULT.equals(message);
			case IModelPackage.PROBLEM_STATE__NEEDINFO:
				return needinfo != null && !needinfo.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (status: ");
		result.append(status);
		result.append(", message: ");
		result.append(message);
		result.append(", needinfo: ");
		result.append(needinfo);
		result.append(')');
		return result.toString();
	}

} //ProblemStateImpl
