import * as lsp from 'vscode-languageserver';
export declare class LspDocument implements lsp.TextDocument {
    protected document: lsp.TextDocument;
    constructor(doc: lsp.TextDocumentItem);
    readonly uri: string;
    readonly languageId: string;
    readonly version: number;
    getText(range?: lsp.Range): string;
    positionAt(offset: number): lsp.Position;
    offsetAt(position: lsp.Position): number;
    readonly lineCount: number;
    getLine(line: number): string;
    getLineRange(line: number): lsp.Range;
    getLineEnd(line: number): lsp.Position;
    getLineOffset(line: number): number;
    getLineStart(line: number): lsp.Position;
    applyEdit(version: number, change: lsp.TextDocumentContentChangeEvent): void;
}
export declare class LspDocuments {
    private readonly _files;
    private readonly documents;
    /**
     * Sorted by last access.
     */
    readonly files: string[];
    get(file: string): LspDocument | undefined;
    open(file: string, doc: lsp.TextDocumentItem): boolean;
    close(file: string): LspDocument | undefined;
}
//# sourceMappingURL=document.d.ts.map