/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network.mailbox.timeless;

import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.rete.network.Direction;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.communication.CommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.communication.MessageSelector;
import org.eclipse.viatra.query.runtime.rete.network.communication.PhasedSelector;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.network.indexer.DefaultMessageIndexer;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.AdaptableMailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.timeless.AbstractUpdateSplittingMailbox;

public class UpdateSplittingMailbox
extends AbstractUpdateSplittingMailbox<DefaultMessageIndexer, Receiver>
implements AdaptableMailbox {
    protected Mailbox adapter = this;

    public UpdateSplittingMailbox(Receiver receiver, ReteContainer container) {
        super(receiver, container, DefaultMessageIndexer::new);
    }

    @Override
    public Mailbox getAdapter() {
        return this.adapter;
    }

    @Override
    public void setAdapter(Mailbox adapter) {
        this.adapter = adapter;
    }

    @Override
    public void postMessage(Direction direction, Tuple update, Timestamp timestamp) {
        boolean wasPresentAsAntiMonotone;
        DefaultMessageIndexer monotoneQueue = (DefaultMessageIndexer)this.getActiveMonotoneQueue();
        DefaultMessageIndexer antiMonotoneQueue = (DefaultMessageIndexer)this.getActiveAntiMonotoneQueue();
        boolean wasPresentAsMonotone = monotoneQueue.getCount(update) != 0;
        boolean bl = wasPresentAsAntiMonotone = antiMonotoneQueue.getCount(update) != 0;
        assert (!wasPresentAsMonotone || !wasPresentAsAntiMonotone);
        if (direction == Direction.INSERT) {
            if (wasPresentAsAntiMonotone) {
                antiMonotoneQueue.insert(update);
            } else {
                monotoneQueue.insert(update);
            }
        } else if (wasPresentAsMonotone) {
            monotoneQueue.delete(update);
        } else {
            antiMonotoneQueue.delete(update);
        }
        Mailbox targetMailbox = this.adapter;
        CommunicationGroup targetGroup = this.adapter.getCurrentGroup();
        if (antiMonotoneQueue.isEmpty()) {
            targetGroup.notifyLostAllMessages(targetMailbox, PhasedSelector.ANTI_MONOTONE);
        } else {
            targetGroup.notifyHasMessage(targetMailbox, PhasedSelector.ANTI_MONOTONE);
        }
        if (monotoneQueue.isEmpty()) {
            targetGroup.notifyLostAllMessages(targetMailbox, PhasedSelector.MONOTONE);
        } else {
            targetGroup.notifyHasMessage(targetMailbox, PhasedSelector.MONOTONE);
        }
    }

    @Override
    public void deliverAll(MessageSelector kind) {
        if (kind == PhasedSelector.ANTI_MONOTONE) {
            this.deliveringAntiMonotone = true;
            for (Map.Entry<Tuple, Integer> entry : ((DefaultMessageIndexer)this.antiMonotoneQueue).getTuples().entrySet()) {
                Tuple update = entry.getKey();
                int count = entry.getValue();
                assert (count < 0);
                int i = 0;
                while (i < Math.abs(count)) {
                    this.receiver.update(Direction.REVOKE, update, Timestamp.ZERO);
                    ++i;
                }
            }
            this.deliveringAntiMonotone = false;
            this.swapAndClearAntiMonotone();
        } else if (kind == PhasedSelector.MONOTONE) {
            this.deliveringMonotone = true;
            for (Map.Entry<Tuple, Integer> entry : ((DefaultMessageIndexer)this.monotoneQueue).getTuples().entrySet()) {
                Tuple update = entry.getKey();
                int count = entry.getValue();
                assert (count > 0);
                int i = 0;
                while (i < count) {
                    this.receiver.update(Direction.INSERT, update, Timestamp.ZERO);
                    ++i;
                }
            }
            this.deliveringMonotone = false;
            this.swapAndClearMonotone();
        } else {
            throw new IllegalArgumentException("Unsupported message kind " + kind);
        }
    }

    public String toString() {
        return "US_MBOX (" + this.receiver + ") " + this.getActiveMonotoneQueue() + " " + this.getActiveAntiMonotoneQueue();
    }
}

