/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.matcher;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackend;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryResultProvider;
import org.eclipse.viatra.query.runtime.matchers.backend.IUpdateable;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.matchers.util.Accuracy;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.rete.index.Indexer;
import org.eclipse.viatra.query.runtime.rete.index.IterableIndexer;
import org.eclipse.viatra.query.runtime.rete.matcher.ReteEngine;
import org.eclipse.viatra.query.runtime.rete.network.Node;
import org.eclipse.viatra.query.runtime.rete.network.ProductionNode;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.remote.Address;
import org.eclipse.viatra.query.runtime.rete.single.CallbackNode;
import org.eclipse.viatra.query.runtime.rete.single.TransformerNode;
import org.eclipse.viatra.query.runtime.rete.traceability.RecipeTraceInfo;

public class RetePatternMatcher
extends TransformerNode
implements IQueryResultProvider {
    protected ReteEngine engine;
    protected IQueryRuntimeContext context;
    protected ProductionNode productionNode;
    protected RecipeTraceInfo productionNodeTrace;
    protected Map<String, Integer> posMapping;
    protected Map<Object, Receiver> taggedChildren = CollectionsFactory.createMap();
    protected boolean connected = false;

    public RetePatternMatcher(ReteEngine engine, RecipeTraceInfo productionNodeTrace) {
        super(engine.getReteNet().getHeadContainer());
        this.engine = engine;
        this.context = engine.getRuntimeContext();
        this.productionNodeTrace = productionNodeTrace;
        Address<? extends Node> productionAddress = this.reteContainer.getProvisioner().getOrCreateNodeByRecipe(productionNodeTrace);
        if (!this.reteContainer.isLocal(productionAddress)) {
            throw new IllegalArgumentException("@pre: Production must be local to the head container");
        }
        this.productionNode = (ProductionNode)this.reteContainer.resolveLocal(productionAddress);
        this.posMapping = this.productionNode.getPosMapping();
        this.reteContainer.getCommunicationTracker().registerDependency(this.productionNode, this);
    }

    public ProductionNode getProductionNode() {
        return this.productionNode;
    }

    public Tuple matchOneRandomly(Object[] inputMapping, boolean[] fixed) {
        List allMatches = this.matchAll(inputMapping, fixed).collect(Collectors.toList());
        if (allMatches == null || allMatches.isEmpty()) {
            return null;
        }
        return (Tuple)allMatches.get((int)(Math.random() * (double)allMatches.size()));
    }

    public Stream<Tuple> matchAll(Object[] inputMapping, boolean[] fixed) {
        TupleMask mask = TupleMask.fromKeepIndicators((boolean[])fixed);
        Tuple inputSignature = mask.transform((ITuple)Tuples.flatTupleOf((Object[])inputMapping));
        return this.matchAll(mask, (ITuple)inputSignature);
    }

    public Stream<Tuple> matchAll(TupleMask mask, ITuple inputSignature) {
        AllMatchFetcher fetcher = new AllMatchFetcher(this.engine.accessProjection(this.productionNodeTrace, mask), this.context.wrapTuple(inputSignature.toImmutable()));
        this.engine.reteNet.waitForReteTermination(fetcher);
        return fetcher.getMatches();
    }

    public Optional<Tuple> matchOne(Object[] inputMapping, boolean[] fixed) {
        TupleMask mask = TupleMask.fromKeepIndicators((boolean[])fixed);
        Tuple inputSignature = mask.transform((ITuple)Tuples.flatTupleOf((Object[])inputMapping));
        return this.matchOne(mask, (ITuple)inputSignature);
    }

    public Optional<Tuple> matchOne(TupleMask mask, ITuple inputSignature) {
        SingleMatchFetcher fetcher = new SingleMatchFetcher(this.engine.accessProjection(this.productionNodeTrace, mask), this.context.wrapTuple(inputSignature.toImmutable()));
        this.engine.reteNet.waitForReteTermination(fetcher);
        return Optional.ofNullable(fetcher.getMatch());
    }

    public int count(Object[] inputMapping, boolean[] fixed) {
        TupleMask mask = TupleMask.fromKeepIndicators((boolean[])fixed);
        Tuple inputSignature = mask.transform((ITuple)Tuples.flatTupleOf((Object[])inputMapping));
        return this.count(mask, (ITuple)inputSignature);
    }

    public int count(TupleMask mask, ITuple inputSignature) {
        CountFetcher fetcher = new CountFetcher(this.engine.accessProjection(this.productionNodeTrace, mask), this.context.wrapTuple(inputSignature.toImmutable()));
        this.engine.reteNet.waitForReteTermination(fetcher);
        return fetcher.getCount();
    }

    public int projectionSize(TupleMask groupMask) {
        ProjectionSizeFetcher fetcher = new ProjectionSizeFetcher((IterableIndexer)this.engine.accessProjection(this.productionNodeTrace, groupMask));
        this.engine.reteNet.waitForReteTermination(fetcher);
        return fetcher.getSize();
    }

    public synchronized void connect(Receiver receiver, boolean synchronize) {
        if (!this.connected) {
            this.reteContainer.connect(this.productionNode, this);
            this.connected = true;
        }
        if (synchronize) {
            this.reteContainer.connectAndSynchronize(this, receiver);
        } else {
            this.reteContainer.connect(this, receiver);
        }
    }

    public synchronized void connect(Receiver receiver, Object tag, boolean synchronize) {
        this.taggedChildren.put(tag, receiver);
        this.connect(receiver, synchronize);
    }

    public synchronized void disconnect(Receiver receiver) {
        this.reteContainer.disconnect(this, receiver);
    }

    public synchronized boolean disconnectByTag(Object tag) {
        boolean found;
        Receiver receiver = this.taggedChildren.remove(tag);
        boolean bl = found = receiver != null;
        if (found) {
            this.disconnect(receiver);
        }
        return found;
    }

    @Override
    protected Tuple transform(Tuple input) {
        return this.context.unwrapTuple(input);
    }

    private boolean[] notNull(Object[] parameters) {
        boolean[] notNull = new boolean[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            notNull[i] = parameters[i] != null;
            ++i;
        }
        return notNull;
    }

    public boolean hasMatch(Object[] parameters) {
        return this.countMatches(parameters) > 0;
    }

    public boolean hasMatch(TupleMask parameterSeedMask, ITuple parameters) {
        return this.count(parameterSeedMask, parameters) > 0;
    }

    public int countMatches(Object[] parameters) {
        return this.count(parameters, this.notNull(parameters));
    }

    public int countMatches(TupleMask parameterSeedMask, ITuple parameters) {
        return this.count(parameterSeedMask, parameters);
    }

    public Optional<Long> estimateCardinality(TupleMask groupMask, Accuracy requiredAccuracy) {
        return Optional.of(Long.valueOf(this.projectionSize(groupMask)));
    }

    public Optional<Tuple> getOneArbitraryMatch(Object[] parameters) {
        return this.matchOne(parameters, this.notNull(parameters));
    }

    public Optional<Tuple> getOneArbitraryMatch(TupleMask parameterSeedMask, ITuple parameters) {
        return this.matchOne(parameterSeedMask, parameters);
    }

    public Stream<Tuple> getAllMatches(Object[] parameters) {
        return this.matchAll(parameters, this.notNull(parameters));
    }

    public Stream<Tuple> getAllMatches(TupleMask parameterSeedMask, ITuple parameters) {
        return this.matchAll(parameterSeedMask, parameters);
    }

    public IQueryBackend getQueryBackend() {
        return this.engine;
    }

    public void addUpdateListener(IUpdateable listener, Object listenerTag, boolean fireNow) {
        CallbackNode callbackNode = new CallbackNode(this.reteContainer, listener);
        this.connect(callbackNode, listenerTag, fireNow);
    }

    public void removeUpdateListener(Object listenerTag) {
        this.disconnectByTag(listenerTag);
    }

    abstract class AbstractMatchFetcher
    implements Runnable {
        Indexer indexer;
        Tuple signature;

        public AbstractMatchFetcher(Indexer indexer, Tuple signature) {
            this.indexer = indexer;
            this.signature = signature;
        }

        @Override
        public void run() {
            this.fetch(this.indexer.get(this.signature));
        }

        protected abstract void fetch(Collection<Tuple> var1);
    }

    class AllMatchFetcher
    extends AbstractMatchFetcher {
        Stream<Tuple> matches;

        public AllMatchFetcher(Indexer indexer, Tuple signature) {
            super(indexer, signature);
            this.matches = null;
        }

        public Stream<Tuple> getMatches() {
            return this.matches;
        }

        @Override
        protected void fetch(Collection<Tuple> matches) {
            this.matches = matches == null ? Stream.of(new Tuple[0]) : matches.stream().map(arg_0 -> ((IQueryRuntimeContext)RetePatternMatcher.this.context).unwrapTuple(arg_0));
        }
    }

    class CountFetcher
    extends AbstractMatchFetcher {
        int count;

        public CountFetcher(Indexer indexer, Tuple signature) {
            super(indexer, signature);
            this.count = 0;
        }

        public int getCount() {
            return this.count;
        }

        @Override
        protected void fetch(Collection<Tuple> matches) {
            this.count = matches == null ? 0 : matches.size();
        }
    }

    class ProjectionSizeFetcher
    implements Runnable {
        IterableIndexer indexer;
        int size = 0;

        public ProjectionSizeFetcher(IterableIndexer indexer) {
            this.indexer = indexer;
        }

        @Override
        public void run() {
            this.size = this.indexer.getBucketCount();
        }

        public int getSize() {
            return this.size;
        }
    }

    class SingleMatchFetcher
    extends AbstractMatchFetcher {
        Tuple match;

        public SingleMatchFetcher(Indexer indexer, Tuple signature) {
            super(indexer, signature);
            this.match = null;
        }

        public Tuple getMatch() {
            return this.match;
        }

        @Override
        protected void fetch(Collection<Tuple> matches) {
            if (matches != null && !matches.isEmpty()) {
                this.match = RetePatternMatcher.this.context.unwrapTuple(matches.iterator().next());
            }
        }
    }
}

