/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event.types;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.nio.ByteOrder;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.Declaration;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.ISimpleDatatypeDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;

public final class EnumDeclaration
extends Declaration
implements ISimpleDatatypeDeclaration {
    private static final Comparator<Pair> OVERLAP_COMPARATOR = (interval1, interval2) -> {
        if (((Pair)interval1).fSecond < ((Pair)interval2).fFirst) {
            return -1;
        }
        if (((Pair)interval1).fFirst > ((Pair)interval2).fSecond) {
            return 1;
        }
        return 0;
    };
    private final @NonNull Map<Pair, String> fEnumTree = new TreeMap<Pair, String>(OVERLAP_COMPARATOR);
    private final IntegerDeclaration fContainerType;
    private Pair fLastAdded = new Pair(-1L, -1L);

    public EnumDeclaration(IntegerDeclaration containerType) {
        this.fContainerType = containerType;
    }

    public EnumDeclaration(IntegerDeclaration containerType, Map<Pair, String> enumTree) {
        this.fContainerType = containerType;
        this.fEnumTree.putAll(enumTree);
    }

    public IntegerDeclaration getContainerType() {
        return this.fContainerType;
    }

    @Override
    public long getAlignment() {
        return this.getContainerType().getAlignment();
    }

    @Override
    public int getMaximumSize() {
        return this.fContainerType.getMaximumSize();
    }

    @Override
    public boolean isByteOrderSet() {
        return this.fContainerType.isByteOrderSet();
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.fContainerType.getByteOrder();
    }

    @Override
    public EnumDefinition createDefinition(@Nullable IDefinitionScope definitionScope, String fieldName, BitBuffer input) throws CTFException {
        this.alignRead(input);
        IntegerDefinition value = this.getContainerType().createDefinition(definitionScope, fieldName, input);
        return new EnumDefinition(this, definitionScope, fieldName, value);
    }

    public boolean add(long low, long high, @Nullable String label) {
        if (high < low) {
            return false;
        }
        Pair key = new Pair(low, high);
        if (!this.fEnumTree.containsKey(key)) {
            this.fEnumTree.put(key, label);
            this.fLastAdded = key;
            return true;
        }
        return false;
    }

    public boolean add(@Nullable String label) {
        return this.add(this.fLastAdded.fSecond + 1L, this.fLastAdded.fSecond + 1L, label);
    }

    public @Nullable String query(long value) {
        return this.fEnumTree.get(new Pair(value, value));
    }

    public Map<Pair, String> getLookupTable() {
        return ImmutableMap.copyOf(this.fEnumTree);
    }

    public Set<String> getLabels() {
        return ImmutableSet.copyOf(this.fEnumTree.values());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[declaration] enum[");
        for (String label : this.fEnumTree.values()) {
            sb.append("label:").append(label).append(' ');
        }
        sb.append("type:").append(this.fContainerType.toString());
        sb.append(']');
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fContainerType, this.fEnumTree);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnumDeclaration other = (EnumDeclaration)obj;
        if (!this.fContainerType.equals(other.fContainerType)) {
            return false;
        }
        return Iterables.elementsEqual(this.fEnumTree.entrySet(), other.fEnumTree.entrySet());
    }

    @Override
    public boolean isBinaryEquivalent(@Nullable IDeclaration obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnumDeclaration other = (EnumDeclaration)obj;
        if (!this.fContainerType.isBinaryEquivalent((IDeclaration)other.fContainerType)) {
            return false;
        }
        return Iterables.elementsEqual(this.fEnumTree.entrySet(), other.fEnumTree.entrySet());
    }

    public static class Pair {
        private final long fFirst;
        private final long fSecond;

        private Pair(long first, long second) {
            this.fFirst = first;
            this.fSecond = second;
        }

        public long getFirst() {
            return this.fFirst;
        }

        public long getSecond() {
            return this.fSecond;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pair other = (Pair)obj;
            return this.fFirst == other.fFirst && this.fSecond == other.fSecond;
        }

        public int hashCode() {
            return Objects.hash(this.fFirst, this.fSecond);
        }
    }
}

