/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.model.AbstractLineList;
import org.eclipse.tm4e.core.model.IModelLines;
import org.eclipse.tm4e.core.model.IModelTokensChangedListener;
import org.eclipse.tm4e.core.model.ITMModel;
import org.eclipse.tm4e.core.model.LineTokens;
import org.eclipse.tm4e.core.model.ModelLine;
import org.eclipse.tm4e.core.model.ModelTokensChangedEvent;
import org.eclipse.tm4e.core.model.ModelTokensChangedEventBuilder;
import org.eclipse.tm4e.core.model.TMState;
import org.eclipse.tm4e.core.model.TMToken;
import org.eclipse.tm4e.core.model.Tokenizer;

public class TMModel
implements ITMModel {
    private static final Logger LOGGER = Logger.getLogger(TMModel.class.getName());
    private IGrammar grammar;
    private final List<IModelTokensChangedListener> listeners;
    Tokenizer tokenizer;
    private TokenizerThread fThread;
    private final IModelLines lines;
    private PriorityBlockingQueue<Integer> invalidLines = new PriorityBlockingQueue();

    public TMModel(IModelLines lines) {
        this.listeners = new ArrayList<IModelTokensChangedListener>();
        this.lines = lines;
        ((AbstractLineList)lines).setModel(this);
        lines.forEach(ModelLine::resetTokenizationState);
        this.invalidateLine(0);
    }

    @Override
    public IGrammar getGrammar() {
        return this.grammar;
    }

    @Override
    public void setGrammar(IGrammar grammar) {
        if (!Objects.equals(grammar, this.grammar)) {
            this.grammar = grammar;
            this.tokenizer = new Tokenizer(grammar);
            this.lines.get(0).setState(this.tokenizer.getInitialState());
        }
    }

    @Override
    public void addModelTokensChangedListener(IModelTokensChangedListener listener) {
        if (this.fThread == null || this.fThread.isInterrupted()) {
            this.fThread = new TokenizerThread(this.getClass().getName(), this);
        }
        if (!this.fThread.isAlive()) {
            this.fThread.start();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeModelTokensChangedListener(IModelTokensChangedListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.stop();
        }
    }

    @Override
    public void dispose() {
        this.stop();
        this.getLines().dispose();
    }

    private void stop() {
        if (this.fThread == null) {
            return;
        }
        this.fThread.interrupt();
        this.fThread = null;
    }

    private void buildEventWithCallback(Consumer<ModelTokensChangedEventBuilder> callback) {
        ModelTokensChangedEventBuilder eventBuilder = new ModelTokensChangedEventBuilder(this);
        callback.accept(eventBuilder);
        ModelTokensChangedEvent e = eventBuilder.build();
        if (e != null) {
            this.emit(e);
        }
    }

    private void emit(ModelTokensChangedEvent e) {
        for (IModelTokensChangedListener listener : this.listeners) {
            listener.modelTokensChanged(e);
        }
    }

    @Override
    public void forceTokenization(int lineNumber) {
        this.buildEventWithCallback(eventBuilder -> {
            int n2 = this.fThread.updateTokensInRange(eventBuilder, lineNumber, lineNumber);
        });
    }

    @Override
    public List<TMToken> getLineTokens(int lineNumber) {
        return this.lines.get((int)lineNumber).tokens;
    }

    public boolean isLineInvalid(int lineNumber) {
        return this.lines.get((int)lineNumber).isInvalid;
    }

    void invalidateLine(int lineIndex) {
        this.lines.get((int)lineIndex).isInvalid = true;
        this.invalidLines.add(lineIndex);
    }

    public IModelLines getLines() {
        return this.lines;
    }

    static class TokenizerThread
    extends Thread {
        private TMModel model;
        private TMState lastState;

        public TokenizerThread(String name, TMModel model) {
            super(name);
            this.model = model;
            this.setPriority(1);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            if (this.isInterrupted()) {
                return;
            }
            do {
                try {
                    Integer toProcess = (Integer)this.model.invalidLines.take();
                    if (!((TMModel)this.model).lines.get((int)toProcess.intValue()).isInvalid) continue;
                    try {
                        this.revalidateTokensNow(toProcess, null);
                    }
                    catch (Exception t) {
                        LOGGER.severe(t.getMessage());
                        if (toProcess >= this.model.lines.getNumberOfLines()) continue;
                        this.model.invalidateLine(toProcess);
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.interrupt();
                }
            } while (!this.isInterrupted() && this.model.fThread != null);
        }

        private void revalidateTokensNow(int startLine, Integer toLineIndexOrNull) {
            this.model.buildEventWithCallback(eventBuilder -> {
                Integer toLineIndex = toLineIndexOrNull;
                if (toLineIndex == null || toLineIndex >= this.model.lines.getNumberOfLines()) {
                    toLineIndex = this.model.lines.getNumberOfLines() - 1;
                }
                long tokenizedChars = 0L;
                long currentCharsToTokenize = 0L;
                long currentEstimatedTimeToTokenize = 0L;
                long startTime = System.currentTimeMillis();
                int lineIndex = startLine;
                while (lineIndex <= toLineIndex && lineIndex < this.model.getLines().getNumberOfLines()) {
                    long elapsedTime = System.currentTimeMillis() - startTime;
                    if (elapsedTime > 20L) {
                        this.model.invalidateLine(lineIndex);
                        return;
                    }
                    try {
                        currentCharsToTokenize = this.model.lines.getLineLength(lineIndex);
                    }
                    catch (Exception e) {
                        LOGGER.severe(e.getMessage());
                    }
                    if (tokenizedChars > 0L && elapsedTime + (currentEstimatedTimeToTokenize = (long)((double)elapsedTime / (double)tokenizedChars) * currentCharsToTokenize) > 20L) {
                        this.model.invalidateLine(lineIndex);
                        return;
                    }
                    lineIndex = this.updateTokensInRange((ModelTokensChangedEventBuilder)eventBuilder, lineIndex, lineIndex) + 1;
                    tokenizedChars += currentCharsToTokenize;
                }
            });
        }

        private int updateTokensInRange(ModelTokensChangedEventBuilder eventBuilder, int startIndex, int endLineIndex) {
            int stopLineTokenizationAfter = 1000000000;
            int nextInvalidLineIndex = startIndex;
            int lineIndex = startIndex;
            while (lineIndex <= endLineIndex && lineIndex < this.model.lines.getNumberOfLines()) {
                int endStateIndex = lineIndex + 1;
                LineTokens r = null;
                String text = null;
                ModelLine modeLine = this.model.lines.get(lineIndex);
                try {
                    text = this.model.lines.getLineText(lineIndex);
                    r = this.model.tokenizer.tokenize(text, modeLine.getState(), 0, stopLineTokenizationAfter);
                }
                catch (Exception e) {
                    LOGGER.severe(e.getMessage());
                }
                if (r != null && r.tokens != null && !r.tokens.isEmpty()) {
                    r.actualStopOffset = Math.max(r.actualStopOffset, r.tokens.get((int)(r.tokens.size() - 1)).startIndex + 1);
                }
                if (r != null && r.actualStopOffset < text.length()) {
                    r.tokens.add(new TMToken(r.actualStopOffset, ""));
                    r.endState = modeLine.getState();
                }
                if (r == null) {
                    r = new LineTokens(Collections.singletonList(new TMToken(0, "")), text.length(), modeLine.getState());
                }
                modeLine.setTokens(r.tokens);
                eventBuilder.registerChangedTokens(lineIndex + 1);
                modeLine.isInvalid = false;
                if (endStateIndex < this.model.lines.getNumberOfLines()) {
                    ModelLine endStateLine = this.model.lines.get(endStateIndex);
                    if (endStateLine.getState() != null && r.endState.equals(endStateLine.getState())) {
                        nextInvalidLineIndex = lineIndex + 1;
                        while (nextInvalidLineIndex < this.model.lines.getNumberOfLines()) {
                            boolean isLastLine;
                            boolean bl = isLastLine = nextInvalidLineIndex + 1 >= this.model.lines.getNumberOfLines();
                            if (((TMModel)this.model).lines.get((int)nextInvalidLineIndex).isInvalid || !isLastLine && this.model.lines.get(nextInvalidLineIndex + 1).getState() == null || isLastLine && this.lastState == null) break;
                            ++nextInvalidLineIndex;
                        }
                        lineIndex = nextInvalidLineIndex;
                        continue;
                    }
                    endStateLine.setState(r.endState);
                    ++lineIndex;
                    continue;
                }
                this.lastState = r.endState;
                ++lineIndex;
            }
            return nextInvalidLineIndex;
        }
    }
}

