/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.aif;

import org.eclipse.ptp.debug.core.pdi.model.aif.AIFException;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeChar;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValueChar;
import org.eclipse.ptp.internal.debug.core.pdi.aif.ValueIntegral;
import org.eclipse.ptp.internal.debug.core.pdi.messages.Messages;
import org.eclipse.ptp.internal.debug.core.pdi.model.aif.AIFFactory;

public class AIFValueChar
extends ValueIntegral
implements IAIFValueChar {
    private byte byteValue;

    public AIFValueChar(IAIFTypeChar type, AIFFactory.SimpleByteBuffer buffer) {
        super(type);
        this.parse(buffer);
    }

    @Override
    protected void parse(AIFFactory.SimpleByteBuffer buffer) {
        this.byteValue = buffer.get();
        this.setSize(this.getType().sizeof());
    }

    @Override
    public String getValueString() throws AIFException {
        char c = this.charValue();
        if (c > ' ' && c < '\u007f') {
            return "'" + String.valueOf(c) + "'";
        }
        return Integer.toString(c & (1 << 8 * this.sizeof()) - 1);
    }

    @Override
    public char charValue() throws AIFException {
        return (char)this.byteValue();
    }

    @Override
    public byte byteValue() throws AIFException {
        return this.byteValue;
    }

    @Override
    public String toString() {
        try {
            return this.toPrintable(this.charValue());
        }
        catch (AIFException e) {
            return String.valueOf(Messages.AIFValueChar_1) + e.getMessage();
        }
    }

    private String toPrintable(char c) {
        if (c < ' ') {
            switch (c) {
                case '\b': {
                    return "\\b";
                }
                case '\f': {
                    return "\\f";
                }
                case '\n': {
                    return "\\n";
                }
                case '\r': {
                    return "\\r";
                }
                case '\t': {
                    return "\\t";
                }
            }
            return String.valueOf(c > '\u000f' ? "\\u00" : "\\u000") + Integer.toHexString(c);
        }
        if (c > '\u0fff') {
            return "\\u" + Integer.toHexString(c);
        }
        if (c > '\u00ff') {
            return "\\u0" + Integer.toHexString(c);
        }
        if (c > '~') {
            return "\\u00" + Integer.toHexString(c);
        }
        return String.valueOf(c);
    }
}

