/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.projectset.impl;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.setup.projectset.ProjectSetImportTask;
import org.eclipse.oomph.setup.projectset.ProjectSetPackage;
import org.eclipse.oomph.setup.projectset.ProjectSetPlugin;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.PropertyFile;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.ProjectSetImporter;
import org.eclipse.team.internal.ui.wizards.ImportProjectSetOperation;
import org.eclipse.ui.IWorkingSet;

public class ProjectSetImportTaskImpl
extends SetupTaskImpl
implements ProjectSetImportTask {
    protected static final String URL_EDEFAULT = null;
    protected String uRL = URL_EDEFAULT;
    private Helper helper;

    protected ProjectSetImportTaskImpl() {
    }

    protected EClass eStaticClass() {
        return ProjectSetPackage.Literals.PROJECT_SET_IMPORT_TASK;
    }

    public String getURL() {
        return this.uRL;
    }

    public void setURL(String newURL) {
        String oldURL = this.uRL;
        this.uRL = newURL;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldURL, (Object)this.uRL));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getURL();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setURL((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setURL(URL_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return URL_EDEFAULT == null ? this.uRL != null : !URL_EDEFAULT.equals(this.uRL);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (uRL: ");
        result.append(this.uRL);
        result.append(')');
        return result.toString();
    }

    public int getProgressMonitorWork() {
        return 100;
    }

    public boolean isNeeded(SetupTaskContext context) throws Exception {
        URI uri = this.createResolvedURI(this.getURL());
        this.helper = new Helper(uri);
        return this.helper.isNeeded(context);
    }

    public void perform(SetupTaskContext context) throws Exception {
        this.helper.perform(context);
    }

    private static class Helper
    extends PropertyFile {
        private static final IWorkspaceRoot ROOT = EcorePlugin.getWorkspaceRoot();
        private static final File HISTORY = ProjectSetPlugin.INSTANCE.getStateLocation().append("import-history.properties").toFile();
        private URI uri;
        private String content;

        public Helper(URI uri) {
            super(HISTORY);
            this.uri = uri;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean isNeeded(SetupTaskContext context) throws Exception {
            try {
                this.content = this.getXMLContent(context.getURIConverter());
                IProject[] projects = this.getProjects(this.uri, this.content);
                if (projects == null) {
                    return true;
                }
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return false;
                    }
                    IProject project = iProjectArray[n2];
                    if (!project.exists()) {
                        return true;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                return true;
            }
        }

        public void perform(SetupTaskContext context) throws Exception {
            if (this.content == null) {
                this.content = this.getXMLContent(context.getURIConverter());
            }
            IProject[] projects = new ImportProjectSetOperation(null, this.content, this.uri.toString(), new IWorkingSet[0]){

                public IProject[] perform(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    return ProjectSetImporter.importProjectSetFromString((String)Helper.this.content, (String)Helper.this.uri.toString(), (Shell)this.getShell(), (IProgressMonitor)monitor);
                }
            }.perform(context.getProgressMonitor(true));
            this.setProjects(this.uri, this.content, projects);
        }

        private String getXMLContent(URIConverter uriConverter) throws Exception {
            String string;
            InputStream inputStream = null;
            try {
                inputStream = uriConverter.createInputStream(this.uri, null);
                string = IOUtil.readXML((InputStream)inputStream);
            }
            catch (Throwable throwable) {
                IOUtil.close(inputStream);
                throw throwable;
            }
            IOUtil.close((Closeable)inputStream);
            return string;
        }

        private IProject[] getProjects(URI uri, String content) {
            String key = uri.toString();
            String value = this.getProperty(key, null);
            if (value != null) {
                String digest = this.getDigest(content);
                ArrayList<IProject> projects = new ArrayList<IProject>();
                boolean confirm = true;
                for (String element : XMLTypeFactory.eINSTANCE.createNMTOKENS(value)) {
                    if (confirm) {
                        if (!digest.equals(element)) {
                            this.removeProperty(key);
                            return null;
                        }
                        confirm = false;
                        continue;
                    }
                    projects.add(ROOT.getProject(URI.decode((String)element)));
                }
                return projects.toArray(new IProject[projects.size()]);
            }
            return null;
        }

        private String getDigest(String contents) {
            try {
                return XMLTypeFactory.eINSTANCE.convertBase64Binary(IOUtil.getSHA1((String)contents));
            }
            catch (Exception ex) {
                ProjectSetPlugin.INSTANCE.log(ex);
                return null;
            }
        }

        private void setProjects(URI uri, String content, IProject[] projects) {
            String key = uri.toString();
            StringBuilder value = new StringBuilder(this.getDigest(content));
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                value.append(' ');
                value.append(URI.encodeSegment((String)project.getName(), (boolean)false));
                ++n2;
            }
            this.setProperty(key, value.toString());
        }
    }
}

