/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPHeuristicScanner;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPIndenter;

public final class IndentUtil {
    private static final String SLASHES = "//";

    private IndentUtil() {
    }

    public static IndentResult indentLines(IDocument document, ILineRange lines, IProject project, IndentResult result) throws BadLocationException {
        int numberOfLines = lines.getNumberOfLines();
        if (numberOfLines < 1) {
            return new IndentResult(null);
        }
        result = IndentUtil.reuseOrCreateToken(result, numberOfLines);
        STPHeuristicScanner scanner = new STPHeuristicScanner(document);
        STPIndenter indenter = new STPIndenter(document, scanner, project);
        boolean indentInsideLineComments = true;
        int line = lines.getStartLine();
        int last = line + numberOfLines;
        int i = 0;
        while (line < last) {
            IndentUtil.indentLine(document, line, indenter, scanner, result.commentLinesAtColumnZero, i++, indentInsideLineComments);
            ++line;
        }
        return result;
    }

    public static String getCurrentIndent(IDocument document, int line, boolean indentInsideLineComments) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        int from = region.getOffset();
        int endOffset = region.getOffset() + region.getLength();
        int to = from;
        if (indentInsideLineComments) {
            while (to < endOffset - 2 && document.get(to, 2).equals(SLASHES)) {
                to += 2;
            }
        }
        while (to < endOffset) {
            char ch = document.getChar(to);
            if (!Character.isWhitespace(ch)) break;
            ++to;
        }
        return document.get(from, to - from);
    }

    private static IndentResult reuseOrCreateToken(IndentResult token, int numberOfLines) {
        if (token == null) {
            token = new IndentResult(new boolean[numberOfLines]);
        } else if (token.commentLinesAtColumnZero == null) {
            token.commentLinesAtColumnZero = new boolean[numberOfLines];
        } else if (token.commentLinesAtColumnZero.length != numberOfLines) {
            boolean[] commentBooleans = new boolean[numberOfLines];
            System.arraycopy(token.commentLinesAtColumnZero, 0, commentBooleans, 0, Math.min(numberOfLines, token.commentLinesAtColumnZero.length));
            token.commentLinesAtColumnZero = commentBooleans;
        }
        return token;
    }

    private static void indentLine(IDocument document, int line, STPIndenter indenter, STPHeuristicScanner scanner, boolean[] commentLines, int lineIndex, boolean indentInsideLineComments) throws BadLocationException {
        ITypedRegion partition;
        int lineLength;
        int end;
        int offset;
        IRegion currentLine = document.getLineInformation(line);
        int wsStart = offset = currentLine.getOffset();
        String indent = null;
        if (offset < document.getLength()) {
            ITypedRegion partition2 = TextUtilities.getPartition((IDocument)document, (String)"__stp_partitioning", (int)offset, (boolean)true);
            ITypedRegion startingPartition = TextUtilities.getPartition((IDocument)document, (String)"__stp_partitioning", (int)offset, (boolean)false);
            String type = partition2.getType();
            if (type.equals("__stp_multiline_comment")) {
                indent = IndentUtil.computeCommentIndent(document, line, scanner, startingPartition);
            } else if (startingPartition.getType().equals("__stp_conditional")) {
                indent = IndentUtil.computePreprocessorIndent(document, line, startingPartition);
            } else if (!commentLines[lineIndex] && startingPartition.getOffset() == offset && startingPartition.getType().equals("__stp_comment")) {
                return;
            }
        }
        if (indent == null) {
            StringBuilder computed = indenter.computeIndentation(offset);
            indent = computed != null ? computed.toString() : "";
        }
        if ((end = scanner.findNonWhitespaceForwardInAnyPartition(wsStart, offset + (lineLength = currentLine.getLength()))) == -1) {
            end = offset + lineLength;
        }
        int length = end - offset;
        String currentIndent = document.get(offset, length);
        if ((length > 0 || !indentInsideLineComments) && (partition = TextUtilities.getPartition((IDocument)document, (String)"__stp_partitioning", (int)end, (boolean)false)).getOffset() == end && "__stp_comment".equals(partition.getType())) {
            commentLines[lineIndex] = true;
        }
        if (!indent.equals(currentIndent)) {
            document.replace(offset, length, indent);
        }
    }

    public static String computeIndent(IDocument document, int line, STPIndenter indenter, STPHeuristicScanner scanner) throws BadLocationException {
        IRegion currentLine = document.getLineInformation(line);
        int offset = currentLine.getOffset();
        String indent = null;
        if (offset < document.getLength()) {
            ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)"__stp_partitioning", (int)offset, (boolean)true);
            ITypedRegion startingPartition = TextUtilities.getPartition((IDocument)document, (String)"__stp_partitioning", (int)offset, (boolean)false);
            String type = partition.getType();
            if (type.equals("__stp_comment")) {
                indent = IndentUtil.computeCommentIndent(document, line, scanner, startingPartition);
            } else if (startingPartition.getType().equals("__stp_conditional")) {
                indent = IndentUtil.computePreprocessorIndent(document, line, startingPartition);
            }
        }
        if (indent == null) {
            StringBuilder computed = indenter.computeIndentation(offset);
            indent = computed != null ? computed.toString() : "";
        }
        return indent;
    }

    public static String computeCommentIndent(IDocument document, int line, STPHeuristicScanner scanner, ITypedRegion partition) throws BadLocationException {
        int lineLength;
        int lineEnd;
        if (line == 0) {
            return null;
        }
        IRegion lineInfo = document.getLineInformation(line);
        int lineStart = lineInfo.getOffset();
        int nonWS = scanner.findNonWhitespaceForwardInAnyPartition(lineStart, lineEnd = lineStart + (lineLength = lineInfo.getLength()));
        if (nonWS == -1 || document.getChar(nonWS) != '*') {
            if (nonWS == -1) {
                return document.get(lineStart, lineLength);
            }
            return document.get(lineStart, nonWS - lineStart);
        }
        IRegion previousLine = document.getLineInformation(line - 1);
        int previousLineStart = previousLine.getOffset();
        int previousLineLength = previousLine.getLength();
        int previousLineEnd = previousLineStart + previousLineLength;
        StringBuilder buf = new StringBuilder();
        int previousLineNonWS = scanner.findNonWhitespaceForwardInAnyPartition(previousLineStart, previousLineEnd);
        if (previousLineNonWS == -1 || document.getChar(previousLineNonWS) != '*') {
            previousLine = document.getLineInformationOfOffset(partition.getOffset());
            previousLineStart = previousLine.getOffset();
            previousLineNonWS = scanner.findNonWhitespaceForwardInAnyPartition(previousLineStart, previousLineEnd = previousLineStart + (previousLineLength = previousLine.getLength()));
            if (previousLineNonWS == -1) {
                previousLineNonWS = previousLineEnd;
            }
            buf.append(' ');
        }
        String indentation = document.get(previousLineStart, previousLineNonWS - previousLineStart);
        buf.insert(0, indentation);
        return buf.toString();
    }

    public static String computePreprocessorIndent(IDocument document, int line, ITypedRegion partition) throws BadLocationException {
        int ppFirstLine = document.getLineOfOffset(partition.getOffset());
        if (line == ppFirstLine) {
            return "";
        }
        STPHeuristicScanner ppScanner = new STPHeuristicScanner(document, "__stp_conditional", partition.getType());
        STPIndenter ppIndenter = new STPIndenter(document, ppScanner);
        if (line == ppFirstLine + 1) {
            return ppIndenter.createReusingIndent(new StringBuilder(), ppIndenter.getContinuationLineIndent(), 0).toString();
        }
        StringBuilder computed = ppIndenter.computeIndentation(document.getLineOffset(line), false);
        if (computed != null) {
            return computed.toString();
        }
        IRegion previousLine = document.getLineInformation(line - 1);
        int previousLineStart = previousLine.getOffset();
        int previousLineLength = previousLine.getLength();
        int previousLineEnd = previousLineStart + previousLineLength;
        int previousLineNonWS = ppScanner.findNonWhitespaceForwardInAnyPartition(previousLineStart, previousLineEnd);
        String previousIndent = document.get(previousLineStart, previousLineNonWS - previousLineStart);
        computed = new StringBuilder(previousIndent);
        return computed.toString();
    }

    public static final class IndentResult {
        private boolean[] commentLinesAtColumnZero;

        private IndentResult(boolean[] commentLines) {
            this.commentLinesAtColumnZero = commentLines;
        }
    }
}

