package org.eclipse.gef.dot.internal.language.serializer;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.language.fontname.FontnamePackage;
import org.eclipse.gef.dot.internal.language.fontname.GravityOption;
import org.eclipse.gef.dot.internal.language.fontname.PangoFontName;
import org.eclipse.gef.dot.internal.language.fontname.PostScriptFontName;
import org.eclipse.gef.dot.internal.language.fontname.StretchOption;
import org.eclipse.gef.dot.internal.language.fontname.StyleOption;
import org.eclipse.gef.dot.internal.language.fontname.VariantOption;
import org.eclipse.gef.dot.internal.language.fontname.WeightOption;
import org.eclipse.gef.dot.internal.language.services.DotFontNameGrammarAccess;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.diagnostic.ISemanticSequencerDiagnosticProvider;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic.Acceptor;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.GenericSequencer;
import org.eclipse.xtext.serializer.sequencer.ISemanticNodeProvider.INodesForEObjectProvider;
import org.eclipse.xtext.serializer.sequencer.ISemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public class DotFontNameSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private DotFontNameGrammarAccess grammarAccess;
	
	public void createSequence(EObject context, EObject semanticObject) {
		if(semanticObject.eClass().getEPackage() == FontnamePackage.eINSTANCE) switch(semanticObject.eClass().getClassifierID()) {
			case FontnamePackage.GRAVITY_OPTION:
				if(context == grammarAccess.getGravityOptionRule() ||
				   context == grammarAccess.getStyleOptionsElementRule()) {
					sequence_GravityOption(context, (GravityOption) semanticObject); 
					return; 
				}
				else break;
			case FontnamePackage.PANGO_FONT_NAME:
				if(context == grammarAccess.getFontNameRule() ||
				   context == grammarAccess.getPangoFontNameRule()) {
					sequence_PangoFontName(context, (PangoFontName) semanticObject); 
					return; 
				}
				else break;
			case FontnamePackage.POST_SCRIPT_FONT_NAME:
				if(context == grammarAccess.getFontNameRule() ||
				   context == grammarAccess.getPostScriptFontNameRule()) {
					sequence_PostScriptFontName(context, (PostScriptFontName) semanticObject); 
					return; 
				}
				else break;
			case FontnamePackage.STRETCH_OPTION:
				if(context == grammarAccess.getStretchOptionRule() ||
				   context == grammarAccess.getStyleOptionsElementRule()) {
					sequence_StretchOption(context, (StretchOption) semanticObject); 
					return; 
				}
				else break;
			case FontnamePackage.STYLE_OPTION:
				if(context == grammarAccess.getStyleOptionRule() ||
				   context == grammarAccess.getStyleOptionsElementRule()) {
					sequence_StyleOption(context, (StyleOption) semanticObject); 
					return; 
				}
				else break;
			case FontnamePackage.VARIANT_OPTION:
				if(context == grammarAccess.getStyleOptionsElementRule() ||
				   context == grammarAccess.getVariantOptionRule()) {
					sequence_VariantOption(context, (VariantOption) semanticObject); 
					return; 
				}
				else break;
			case FontnamePackage.WEIGHT_OPTION:
				if(context == grammarAccess.getStyleOptionsElementRule() ||
				   context == grammarAccess.getWeightOptionRule()) {
					sequence_WeightOption(context, (WeightOption) semanticObject); 
					return; 
				}
				else break;
			}
		if (errorAcceptor != null) errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Constraint:
	 *     gravity=Gravity
	 */
	protected void sequence_GravityOption(EObject context, GravityOption semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, FontnamePackage.Literals.GRAVITY_OPTION__GRAVITY) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, FontnamePackage.Literals.GRAVITY_OPTION__GRAVITY));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getGravityOptionAccess().getGravityGravityParserRuleCall_0(), semanticObject.getGravity());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     (families+=PangoFamily* styleOptionsList+=StyleOptionsElement*)
	 */
	protected void sequence_PangoFontName(EObject context, PangoFontName semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     alias=PostScriptAlias
	 */
	protected void sequence_PostScriptFontName(EObject context, PostScriptFontName semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, FontnamePackage.Literals.POST_SCRIPT_FONT_NAME__ALIAS) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, FontnamePackage.Literals.POST_SCRIPT_FONT_NAME__ALIAS));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getPostScriptFontNameAccess().getAliasPostScriptAliasParserRuleCall_0(), semanticObject.getAlias());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     stretch=Stretch
	 */
	protected void sequence_StretchOption(EObject context, StretchOption semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, FontnamePackage.Literals.STRETCH_OPTION__STRETCH) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, FontnamePackage.Literals.STRETCH_OPTION__STRETCH));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getStretchOptionAccess().getStretchStretchParserRuleCall_0(), semanticObject.getStretch());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     style=Style
	 */
	protected void sequence_StyleOption(EObject context, StyleOption semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, FontnamePackage.Literals.STYLE_OPTION__STYLE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, FontnamePackage.Literals.STYLE_OPTION__STYLE));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getStyleOptionAccess().getStyleStyleParserRuleCall_0(), semanticObject.getStyle());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     variant=Variant
	 */
	protected void sequence_VariantOption(EObject context, VariantOption semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, FontnamePackage.Literals.VARIANT_OPTION__VARIANT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, FontnamePackage.Literals.VARIANT_OPTION__VARIANT));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getVariantOptionAccess().getVariantVariantParserRuleCall_0(), semanticObject.getVariant());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     weight=Weight
	 */
	protected void sequence_WeightOption(EObject context, WeightOption semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, FontnamePackage.Literals.WEIGHT_OPTION__WEIGHT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, FontnamePackage.Literals.WEIGHT_OPTION__WEIGHT));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getWeightOptionAccess().getWeightWeightParserRuleCall_0(), semanticObject.getWeight());
		feeder.finish();
	}
}
