/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.schemaobjecteditor.ui.pages.ddl;

import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.pages.ddl.SQLCommentScanner;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.pages.ddl.SingleTokenSQLScanner;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLCodeScanner;
import org.eclipse.datatools.sqltools.sqleditor.internal.sql.SQLDoubleClickStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class SQLSourceViewerConfiguration
extends SourceViewerConfiguration {
    private ITokenScanner _SQLCodeScanner;
    private ITokenScanner _SQLStringScanner;
    private ITokenScanner _multilineCommentScanner;
    private ITokenScanner _singlelineCommentScanner;
    private ITokenScanner _SQLDoubleQuotesIdentifierScanner;
    private String _dbType = null;

    public SQLSourceViewerConfiguration(String dbType) {
        this._dbType = dbType;
        this.initializeScanners();
    }

    private void initializeScanners() {
        this._SQLCodeScanner = new SQLCodeScanner(SQLEditorPlugin.getDefault().getSQLColorProvider());
        ((SQLCodeScanner)this._SQLCodeScanner).setSQLSyntax(SQLToolsFacade.getSQLSyntax((String)this._dbType));
        this._multilineCommentScanner = new SQLCommentScanner("sql_multiline_comment");
        this._singlelineCommentScanner = new SQLCommentScanner("sql_comment");
        this._SQLDoubleQuotesIdentifierScanner = new SingleTokenSQLScanner("sql_double_quotes_identifier");
        this._SQLStringScanner = new SingleTokenSQLScanner("sql_character");
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning("___sql_partitioning");
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer(this._SQLCodeScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer(this._multilineCommentScanner);
        reconciler.setDamager((IPresentationDamager)dr, "sql_multiline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "sql_multiline_comment");
        dr = new DefaultDamagerRepairer(this._singlelineCommentScanner);
        reconciler.setDamager((IPresentationDamager)dr, "sql_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "sql_comment");
        dr = new DefaultDamagerRepairer(this._SQLStringScanner);
        reconciler.setDamager((IPresentationDamager)dr, "sql_character");
        reconciler.setRepairer((IPresentationRepairer)dr, "sql_character");
        dr = new DefaultDamagerRepairer(this._SQLDoubleQuotesIdentifierScanner);
        reconciler.setDamager((IPresentationDamager)dr, "sql_double_quotes_identifier");
        reconciler.setRepairer((IPresentationRepairer)dr, "sql_double_quotes_identifier");
        dr = new DefaultDamagerRepairer(this._SQLCodeScanner);
        reconciler.setDamager((IPresentationDamager)dr, "sql_code");
        reconciler.setRepairer((IPresentationRepairer)dr, "sql_code");
        return reconciler;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return new SQLDoubleClickStrategy();
    }
}

