/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.visualizer.ui.util;

import org.eclipse.cdt.visualizer.ui.util.ListenerList;
import org.eclipse.cdt.visualizer.ui.util.SelectionUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class SelectionManager
implements ISelectionProvider {
    protected ISelectionProvider m_source = null;
    protected String m_label = null;
    protected ISelection m_selection = SelectionUtils.EMPTY_SELECTION;
    protected ListenerList m_selectionListeners = null;
    protected boolean m_selectionEventsEnabled = true;

    public SelectionManager(ISelectionProvider source, String label) {
        this.m_source = source == null ? this : source;
        this.m_label = label;
        this.m_selectionListeners = new ListenerList(this, String.valueOf(label) + ", listener list"){

            @Override
            public void raise(Object listener, Object event) {
                if (listener instanceof ISelectionChangedListener && event instanceof SelectionChangedEvent) {
                    ISelectionChangedListener typedListener = (ISelectionChangedListener)listener;
                    SelectionChangedEvent typedEvent = (SelectionChangedEvent)event;
                    typedListener.selectionChanged(typedEvent);
                }
            }
        };
    }

    public void dispose() {
        this.m_selectionEventsEnabled = false;
        this.m_selection = SelectionUtils.EMPTY_SELECTION;
        if (this.m_selectionListeners != null) {
            this.m_selectionListeners.clear();
            this.m_selectionListeners = null;
        }
        this.m_source = null;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener == null) {
            return;
        }
        this.m_selectionListeners.addListener(listener);
        listener.selectionChanged(new SelectionChangedEvent(this.m_source, this.getSelection()));
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener == null) {
            return;
        }
        this.m_selectionListeners.removeListener(listener);
    }

    public ISelection getSelection() {
        return this.m_selection;
    }

    public void setSelection(ISelection selection) {
        this.setSelection(selection, true);
    }

    public void setSelection(ISelectionProvider provider, ISelection selection) {
        this.setSelection(provider, selection, true);
    }

    public void setSelection(ISelection selection, boolean raiseEvent) {
        if (selection == null) {
            selection = SelectionUtils.EMPTY_SELECTION;
        }
        this.m_selection = selection;
        if (raiseEvent) {
            this.raiseSelectionChangedEvent();
        }
    }

    public void setSelection(ISelectionProvider provider, ISelection selection, boolean raiseEvent) {
        if (selection == null) {
            selection = SelectionUtils.EMPTY_SELECTION;
        }
        this.m_selection = selection;
        if (raiseEvent) {
            this.raiseSelectionChangedEvent(provider);
        }
    }

    public boolean hasSelection() {
        return SelectionUtils.getSelectionSize(this.m_selection) > 0;
    }

    public boolean getSelectionEventsEnabled() {
        return this.m_selectionEventsEnabled;
    }

    public void setSelectionEventsEnabled(boolean enabled) {
        this.m_selectionEventsEnabled = enabled;
    }

    public void raiseSelectionChangedEvent() {
        if (this.m_selectionEventsEnabled) {
            this.m_selectionListeners.raise(new SelectionChangedEvent(this.m_source, this.getSelection()));
        }
    }

    public void raiseSelectionChangedEvent(ISelectionProvider provider) {
        if (this.m_selectionEventsEnabled) {
            this.m_selectionListeners.raise(new SelectionChangedEvent(provider, this.getSelection()));
        }
    }
}

