/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICDebugElement;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsView;
import org.eclipse.debug.internal.ui.views.launch.LaunchView;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public abstract class ViewFilterAction
extends ViewerFilter
implements IViewActionDelegate,
IActionDelegate2 {
    private IViewPart fView;
    private IAction fAction;

    public void init(IViewPart view) {
        this.fView = view;
        this.fAction.setChecked(this.getPreferenceValue(view));
        this.run(this.fAction);
    }

    public void init(IAction action) {
        this.fAction = action;
    }

    public void dispose() {
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void run(IAction action) {
        StructuredViewer viewer = this.getStructuredViewer();
        ViewerFilter[] filters = viewer.getFilters();
        ViewerFilter filter = null;
        int i = 0;
        while (i < filters.length) {
            if (filters[i] == this) {
                filter = filters[i];
                break;
            }
            ++i;
        }
        if (filter == null) {
            viewer.addFilter((ViewerFilter)this);
        }
        viewer.refresh();
        IPreferenceStore store = this.getPreferenceStore();
        String key = String.valueOf(this.getView().getSite().getId()) + "." + this.getPreferenceKey();
        store.setValue(key, action.isChecked());
        CDebugUIPlugin.getDefault().savePluginPreferences();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enable = false;
        IDebugView view = (IDebugView)this.getView().getAdapter(IDebugView.class);
        if (view instanceof LaunchView) {
            IDebugTarget[] debugTargets;
            ILaunchManager launchmgr = DebugPlugin.getDefault().getLaunchManager();
            IDebugTarget[] iDebugTargetArray = debugTargets = launchmgr.getDebugTargets();
            int n = debugTargets.length;
            int n2 = 0;
            while (n2 < n) {
                IDebugTarget debugTarget = iDebugTargetArray[n2];
                if (debugTarget instanceof ICDebugElement) {
                    enable = true;
                    break;
                }
                ++n2;
            }
        } else if (view instanceof BreakpointsView) {
            IBreakpoint[] bkpts;
            IBreakpointManager bkptmgr = DebugPlugin.getDefault().getBreakpointManager();
            IBreakpoint[] iBreakpointArray = bkpts = bkptmgr.getBreakpoints();
            int n = bkpts.length;
            int n3 = 0;
            while (n3 < n) {
                IBreakpoint bkpt = iBreakpointArray[n3];
                if (bkpt instanceof ICBreakpoint) {
                    enable = true;
                    break;
                }
                ++n3;
            }
        } else {
            enable = true;
        }
        this.fAction.setEnabled(enable);
    }

    protected IPreferenceStore getPreferenceStore() {
        return CDebugUIPlugin.getDefault().getPreferenceStore();
    }

    protected boolean getPreferenceValue(IViewPart part) {
        String key = String.valueOf(part.getSite().getId()) + "." + this.getPreferenceKey();
        return this.getPreferenceStore().getBoolean(key);
    }

    protected abstract String getPreferenceKey();

    protected IViewPart getView() {
        return this.fView;
    }

    protected StructuredViewer getStructuredViewer() {
        Viewer viewer;
        IDebugView view = (IDebugView)this.getView().getAdapter(IDebugView.class);
        if (view != null && (viewer = view.getViewer()) instanceof StructuredViewer) {
            return (StructuredViewer)viewer;
        }
        return null;
    }

    protected boolean getValue() {
        return this.fAction.isChecked();
    }

    protected void setEnabled(boolean enabled) {
        this.fAction.setEnabled(enabled);
    }
}

