/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.core.builder;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.xtend.shared.ui.core.builder.XtendXpandMarkerManager;
import org.eclipse.xtend.shared.ui.core.builder.XtendXpandNature;
import org.eclipse.xtend.shared.ui.internal.XtendLog;

public class XtendXpandNatureUtil {
    public static final boolean addExtXptNature(final IProject project) {
        block7: {
            try {
                IProjectDescription description = project.getDescription();
                String[] natures = description.getNatureIds();
                boolean containsNature = false;
                String[] stringArray = natures;
                int n = natures.length;
                int n2 = 0;
                while (n2 < n) {
                    String nature = stringArray[n2];
                    if (XtendXpandNature.NATURE_ID.equals(nature)) {
                        containsNature = true;
                    }
                    ++n2;
                }
                if (containsNature) break block7;
                String[] newNatures = new String[natures.length + 1];
                System.arraycopy(natures, 0, newNatures, 0, natures.length);
                newNatures[natures.length] = XtendXpandNature.NATURE_ID;
                description.setNatureIds(newNatures);
                project.setDescription(description, null);
                try {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException {
                            try {
                                project.build(15, monitor);
                            }
                            catch (CoreException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    XtendLog.logError(e);
                }
                catch (InterruptedException e) {
                    XtendLog.logError(e);
                }
                return true;
            }
            catch (CoreException e) {
                XtendLog.logError(e);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean removeExtXptNature(final IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            int i = 0;
            while (true) {
                if (i >= natures.length) {
                    return false;
                }
                if (XtendXpandNature.NATURE_ID.equals(natures[i])) {
                    String[] newNatures = new String[natures.length - 1];
                    System.arraycopy(natures, 0, newNatures, 0, i);
                    System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
                    description.setNatureIds(newNatures);
                    project.setDescription(description, null);
                    try {
                        new WorkspaceModifyOperation(){

                            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                                XtendXpandMarkerManager.deleteMarkers((IResource)project);
                            }
                        }.run((IProgressMonitor)new NullProgressMonitor());
                        return true;
                    }
                    catch (InvocationTargetException e) {
                        XtendLog.logError(e);
                        return true;
                    }
                    catch (InterruptedException e) {
                        XtendLog.logError(e);
                    }
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            XtendLog.logError(e);
        }
        return false;
    }

    public static boolean hasExtXptNature(IProject project) {
        try {
            return project.hasNature(XtendXpandNature.NATURE_ID);
        }
        catch (CoreException e) {
            return false;
        }
    }
}

