/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.classic;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.IntegerRangeCondition;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTConfig;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTNode;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.ParentNode;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;

public final class CoreNode
extends ParentNode {
    private int fNbChildren = 0;
    private int[] fChildren;
    private long[] fChildStart;
    private long[] fChildEnd;
    private int[] fChildMin;
    private int[] fChildMax;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock(false);

    public CoreNode(HTConfig config, int seqNumber, int parentSeqNumber, long start) {
        super(config, seqNumber, parentSeqNumber, start);
        int size = config.getMaxChildren();
        this.fChildren = new int[size];
        this.fChildStart = new long[size];
        Arrays.fill(this.fChildStart, Long.MIN_VALUE);
        this.fChildEnd = new long[size];
        Arrays.fill(this.fChildEnd, Long.MAX_VALUE);
        this.fChildMin = new int[size];
        this.fChildMax = new int[size];
        Arrays.fill(this.fChildMax, Integer.MAX_VALUE);
    }

    @Override
    protected void readSpecificHeader(ByteBuffer buffer) {
        int size = this.getConfig().getMaxChildren();
        this.fNbChildren = buffer.getInt();
        this.fChildren = new int[size];
        int i = 0;
        while (i < size) {
            this.fChildren[i] = buffer.getInt();
            ++i;
        }
        this.fChildStart = new long[size];
        i = 0;
        while (i < size) {
            this.fChildStart[i] = buffer.getLong();
            ++i;
        }
        this.fChildEnd = new long[size];
        i = 0;
        while (i < size) {
            this.fChildEnd[i] = buffer.getLong();
            ++i;
        }
        this.fChildMin = new int[size];
        i = 0;
        while (i < size) {
            this.fChildMin[i] = buffer.getInt();
            ++i;
        }
        this.fChildMax = new int[size];
        i = 0;
        while (i < size) {
            this.fChildMax[i] = buffer.getInt();
            ++i;
        }
    }

    @Override
    protected void writeSpecificHeader(ByteBuffer buffer) {
        buffer.putInt(this.fNbChildren);
        int[] nArray = this.fChildren;
        int n = this.fChildren.length;
        int n2 = 0;
        while (n2 < n) {
            int child = nArray[n2];
            buffer.putInt(child);
            ++n2;
        }
        long[] lArray = this.fChildStart;
        int n3 = this.fChildStart.length;
        n = 0;
        while (n < n3) {
            long start = lArray[n];
            buffer.putLong(start);
            ++n;
        }
        lArray = this.fChildEnd;
        n3 = this.fChildEnd.length;
        n = 0;
        while (n < n3) {
            long end = lArray[n];
            buffer.putLong(end);
            ++n;
        }
        int[] nArray2 = this.fChildMin;
        n = this.fChildMin.length;
        n2 = 0;
        while (n2 < n) {
            int min = nArray2[n2];
            buffer.putInt(min);
            ++n2;
        }
        nArray2 = this.fChildMax;
        n = this.fChildMax.length;
        n2 = 0;
        while (n2 < n) {
            int max = nArray2[n2];
            buffer.putInt(max);
            ++n2;
        }
    }

    @Override
    public int getNbChildren() {
        this.rwl.readLock().lock();
        try {
            int n = this.fNbChildren;
            return n;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public int getChild(int index) {
        this.rwl.readLock().lock();
        try {
            int n = this.fChildren[index];
            return n;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public int getLatestChild() {
        this.rwl.readLock().lock();
        try {
            int n = this.fChildren[this.fNbChildren - 1];
            return n;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public long getChildStart(int index) {
        this.rwl.readLock().lock();
        try {
            long l = this.fChildStart[index];
            return l;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public long getChildEnd(int index) {
        this.rwl.readLock().lock();
        try {
            long l = this.fChildEnd[index];
            return l;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    public int closeChild(HTNode child) {
        int childSequenceNumber = child.getSequenceNumber();
        int i = 0;
        while (i < this.getNbChildren()) {
            if (childSequenceNumber == this.getChild(i)) {
                this.fChildEnd[i] = child.getNodeEnd();
                this.fChildMin[i] = child.getMinQuark();
                this.fChildMax[i] = child.getMaxQuark();
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void linkNewChild(HTNode childNode) {
        this.rwl.writeLock().lock();
        try {
            if (this.fNbChildren >= this.getConfig().getMaxChildren()) {
                throw new IllegalStateException("Asked to link another child but parent already has maximum number of children");
            }
            this.fChildren[this.fNbChildren] = childNode.getSequenceNumber();
            this.fChildStart[this.fNbChildren] = childNode.getNodeStart();
            ++this.fNbChildren;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @Override
    public Collection<Integer> selectNextChildren(long t) throws TimeRangeException {
        if (t < this.getNodeStart() || this.isOnDisk() && t > this.getNodeEnd()) {
            throw new TimeRangeException("Requesting children outside the node's range: " + t);
        }
        this.rwl.readLock().lock();
        try {
            ArrayList<Integer> next = new ArrayList<Integer>();
            int i = 0;
            while (i < this.fNbChildren) {
                if (t >= this.fChildStart[i] && t <= this.fChildEnd[i]) {
                    next.add(this.fChildren[i]);
                }
                ++i;
            }
            ArrayList<Integer> arrayList = next;
            return arrayList;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public Collection<Integer> selectNextChildren(long t, int k) throws TimeRangeException {
        if (t < this.getNodeStart() || this.isOnDisk() && t > this.getNodeEnd()) {
            throw new TimeRangeException("Requesting children outside the node's range: " + t);
        }
        this.rwl.readLock().lock();
        try {
            ArrayList<Integer> next = new ArrayList<Integer>();
            int i = 0;
            while (i < this.fNbChildren) {
                if (t >= this.fChildStart[i] && t <= this.fChildEnd[i] && k >= this.fChildMin[i] && k <= this.fChildMax[i]) {
                    next.add(this.fChildren[i]);
                }
                ++i;
            }
            ArrayList<Integer> arrayList = next;
            return arrayList;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public void queueNextChildren2D(IntegerRangeCondition quarks, TimeRangeCondition times, Deque<Integer> queue, boolean reverse) {
        this.rwl.readLock().lock();
        try {
            ArrayDeque<Integer> toAdd = new ArrayDeque<Integer>();
            int child = 0;
            while (child < this.fNbChildren) {
                if (times.intersects(this.fChildStart[child], this.fChildEnd[child]) && quarks.intersects(this.fChildMin[child], this.fChildMax[child])) {
                    int potentialNextSeqNb = this.fChildren[child];
                    if (!reverse) {
                        toAdd.addFirst(potentialNextSeqNb);
                    } else {
                        toAdd.add(potentialNextSeqNb);
                    }
                }
                ++child;
            }
            for (Integer seqNum : toAdd) {
                queue.addFirst(seqNum);
            }
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public HTNode.NodeType getNodeType() {
        return HTNode.NodeType.CORE;
    }

    @Override
    protected int getSpecificHeaderSize() {
        int maxChildren = this.getConfig().getMaxChildren();
        return 4 + 4 * maxChildren + 8 * maxChildren + 8 * maxChildren + 8 * maxChildren;
    }

    @Override
    public int getMinQuark() {
        int min = super.getMinQuark();
        this.rwl.readLock().lock();
        try {
            int i = 0;
            while (i < this.fNbChildren) {
                min = Integer.min(min, this.fChildMin[i]);
                ++i;
            }
            int n = min;
            return n;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public int getMaxQuark() {
        int max = super.getMaxQuark();
        this.rwl.readLock().lock();
        try {
            int i = 0;
            while (i < this.fNbChildren) {
                max = Integer.max(max, this.fChildMax[i]);
                ++i;
            }
            int n = max;
            return n;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public String toStringSpecific() {
        return String.format("Core Node, %d children %s", this.fNbChildren, Arrays.toString(Arrays.copyOf(this.fChildren, this.fNbChildren)));
    }
}

