/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo;

import java.io.File;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.debuginfo.FileOffsetMapper;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.BinaryCallsite;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.Messages;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.UstDebugInfoBinaryAspect;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.lookup.TmfCallsite;

public class UstDebugInfoSourceAspect
implements ITmfEventAspect<TmfCallsite> {
    public static final UstDebugInfoSourceAspect INSTANCE = new UstDebugInfoSourceAspect();

    private UstDebugInfoSourceAspect() {
    }

    public String getName() {
        return NonNullUtils.nullToEmptyString((Object)Messages.UstDebugInfoAnalysis_SourceAspectName);
    }

    public String getHelpText() {
        return NonNullUtils.nullToEmptyString((Object)Messages.UstDebugInfoAnalysis_SourceAspectHelpText);
    }

    public @Nullable TmfCallsite resolve(ITmfEvent event) {
        if (!(event.getTrace() instanceof LttngUstTrace)) {
            return null;
        }
        LttngUstTrace trace = (LttngUstTrace)event.getTrace();
        BinaryCallsite bc = UstDebugInfoBinaryAspect.INSTANCE.resolve(event);
        if (bc == null) {
            return null;
        }
        TmfCallsite callsite = FileOffsetMapper.getCallsiteFromOffset(new File(bc.getBinaryFilePath()), bc.getBuildId(), bc.getOffset());
        if (callsite == null) {
            return null;
        }
        String pathPrefix = trace.getSymbolProviderConfig().getActualRootDirPath();
        if (pathPrefix.isEmpty()) {
            return callsite;
        }
        String fullFileName = String.valueOf(pathPrefix) + callsite.getFileName();
        return new TmfCallsite(fullFileName, callsite.getLineNo());
    }
}

