/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer;

import java.util.ArrayList;
import org.eclipse.photran.internal.core.preprocessor.c.CppHelper;
import org.eclipse.photran.internal.core.preprocessor.c.IToken;

public class ProducerMap {
    private final StringWithOffset[] mapping;
    private final int finalOffset;
    private int markA;
    private int markB;
    private int indexPreA;
    private int indexPostB;

    public ProducerMap(IToken token) {
        ArrayList<StringWithOffset> mappingAL = new ArrayList<StringWithOffset>();
        int offset = 0;
        IToken lastProducer = null;
        IToken tok = token;
        IToken prevTok = null;
        while (tok != null) {
            IToken producer = CppHelper.getAncestor(tok, true);
            if (producer == tok) {
                producer = null;
            }
            if (lastProducer != null && producer != lastProducer) {
                mappingAL.add(new StringWithOffset(null, offset));
            }
            offset += CppHelper.getPreWhiteSpaceLength(tok);
            if (producer != null && producer != lastProducer) {
                mappingAL.add(new StringWithOffset(CppHelper.getImage(producer), offset));
            }
            offset += CppHelper.getImageLength(tok);
            lastProducer = producer;
            prevTok = tok;
            tok = tok.getNext();
        }
        this.finalOffset = offset;
        if (mappingAL.size() > 0) {
            StringWithOffset lastSWO = (StringWithOffset)mappingAL.get(mappingAL.size() - 1);
            if (lastSWO.offset < this.finalOffset || lastSWO.string != null) {
                mappingAL.add(new StringWithOffset(null, this.finalOffset));
            }
        } else {
            mappingAL.add(new StringWithOffset(null, this.finalOffset));
        }
        mappingAL.add(new StringWithOffset(null, this.finalOffset + 1));
        if (((StringWithOffset)mappingAL.get(0)).offset == 0) {
            this.mapping = new StringWithOffset[mappingAL.size()];
            int i = 0;
            while (i < this.mapping.length) {
                this.mapping[i] = (StringWithOffset)mappingAL.get(i);
                ++i;
            }
        } else {
            this.mapping = new StringWithOffset[mappingAL.size() + 1];
            this.mapping[0] = new StringWithOffset(null, 0);
            int i = 1;
            while (i < this.mapping.length) {
                this.mapping[i] = (StringWithOffset)mappingAL.get(i - 1);
                ++i;
            }
        }
        this.reset();
    }

    public ProducerMap(ProducerMap original) {
        this.mapping = original.mapping;
        this.finalOffset = original.finalOffset;
        this.reset();
    }

    public void reset() {
        this.markA = 0;
        this.markB = 0;
        this.indexPreA = 0;
        this.indexPostB = 0;
    }

    public void setMarkA(int newMarkA) {
        int offset;
        if (newMarkA < this.markA) {
            throw new IllegalArgumentException("newMarkA must be >= markA");
        }
        if (newMarkA > this.finalOffset) {
            throw new IllegalArgumentException("newMarkA must be <= the final offset");
        }
        while ((offset = this.mapping[this.indexPreA].offset) != newMarkA) {
            if (offset > newMarkA) {
                --this.indexPreA;
                break;
            }
            ++this.indexPreA;
        }
        this.markA = newMarkA;
        if (newMarkA > this.markB) {
            this.setMarkB(newMarkA);
        }
    }

    public void setMarkB(int newMarkB) {
        int offset;
        if (newMarkB < this.markB) {
            throw new IllegalArgumentException("newMarkB must be >= markB");
        }
        if (newMarkB > this.finalOffset) {
            throw new IllegalArgumentException("newMarkB must be <= the final offset");
        }
        boolean wasEqual = false;
        while ((offset = this.mapping[this.indexPostB].offset) <= newMarkB) {
            wasEqual = offset == newMarkB;
            ++this.indexPostB;
        }
        if (wasEqual) {
            --this.indexPostB;
        }
        this.markB = newMarkB;
    }

    public String expandWhite(String image) {
        if (image.length() != this.markB - this.markA) {
            throw new IllegalArgumentException("the length of image must equal markB-markA");
        }
        if (this.indexPreA == this.indexPostB) {
            return null;
        }
        if (this.indexPreA + 1 == this.indexPostB) {
            if (this.mapping[this.indexPreA].string == null) {
                return null;
            }
            if (this.mapping[this.indexPreA].offset == this.markA && this.mapping[this.indexPostB].offset == this.markB) {
                return this.mapping[this.indexPreA].string;
            }
            return "";
        }
        StringBuffer buffer = new StringBuffer(256);
        int index = this.indexPreA;
        if (this.mapping[index].offset < this.markA) {
            if (this.mapping[index].string == null) {
                buffer.append(image.substring(0, this.mapping[index + 1].offset - this.markA));
            }
            ++index;
        }
        while (index < this.indexPostB) {
            if (index + 1 == this.indexPostB && this.mapping[index + 1].offset > this.markB) {
                if (this.mapping[index].string != null) break;
                buffer.append(image.substring(this.mapping[index].offset - this.markA));
                break;
            }
            if (this.mapping[index].string == null) {
                buffer.append(image.substring(this.mapping[index].offset - this.markA, this.mapping[index + 1].offset - this.markA));
            } else {
                buffer.append(this.mapping[index].string);
            }
            ++index;
        }
        return buffer.toString();
    }

    public String expandNormal(String image) {
        if (image.length() != this.markB - this.markA) {
            throw new IllegalArgumentException("the length of image must equal markB-markA");
        }
        int index = this.indexPreA;
        int endIndex = this.indexPostB;
        while (index < endIndex) {
            if (this.mapping[index + 1].offset != this.markA) break;
            ++index;
        }
        while (index < endIndex) {
            if (this.mapping[endIndex - 1].offset != this.markB) break;
            --endIndex;
        }
        if (index == endIndex) {
            return null;
        }
        if (index + 1 == endIndex) {
            if (this.mapping[index].string == null) {
                return null;
            }
            return this.mapping[index].string;
        }
        StringBuffer buffer = new StringBuffer(256);
        while (index < endIndex) {
            if (this.mapping[index].string == null) {
                int subEnd;
                int subStart = this.mapping[index].offset - this.markA;
                if (subStart < 0) {
                    subStart = 0;
                }
                if ((subEnd = this.mapping[index + 1].offset - this.markA) > image.length()) {
                    subEnd = image.length();
                }
                buffer.append(image.substring(subStart, subEnd));
            } else {
                buffer.append(this.mapping[index].string);
            }
            ++index;
        }
        return buffer.toString();
    }

    public boolean isMarkBInProducer() {
        if (this.mapping[this.indexPostB].offset == this.markB) {
            return false;
        }
        StringWithOffset preSWO = this.mapping[this.indexPostB - 1];
        if (preSWO.offset == this.markB) {
            return false;
        }
        return preSWO.string != null;
    }

    public boolean isBreakAfterMarkB(int endOffset) {
        if (endOffset < this.markB) {
            throw new IllegalArgumentException("endOffset must be >= markB");
        }
        if (this.mapping[this.indexPostB].offset <= endOffset) {
            return true;
        }
        return this.mapping[this.indexPostB - 1].string == null;
    }

    public int getFinalOffset() {
        return this.finalOffset;
    }

    private static class StringWithOffset {
        private final String string;
        private final int offset;

        private StringWithOffset(String string, int offset) {
            this.string = string == null ? null : new String(string);
            this.offset = offset;
        }
    }
}

