/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.declaration;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.declaration.LSBasedHyperlink;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;

public class OpenDeclarationHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        Collection res;
        block8: {
            URI uri;
            IDocument document;
            block7: {
                document = textViewer.getDocument();
                try {
                    uri = LSPEclipseUtils.toUri(document);
                    if (uri != null) break block7;
                    return null;
                }
                catch (BadLocationException e1) {
                    LanguageServerPlugin.logError(e1);
                    return null;
                }
            }
            TextDocumentPositionParams params = new TextDocumentPositionParams(new TextDocumentIdentifier(uri.toString()), LSPEclipseUtils.toPosition(region.getOffset(), document));
            IRegion r = this.findWord(textViewer.getDocument(), region.getOffset());
            IRegion linkRegion = r != null ? r : region;
            res = (Collection)((CompletableFuture)LanguageServiceAccessor.getLanguageServers(textViewer.getDocument(), capabilities -> Boolean.TRUE.equals(capabilities.getDefinitionProvider())).thenComposeAsync(languageServers -> {
                Set allLinks = Collections.synchronizedSet(new HashSet(languageServers.size()));
                return CompletableFuture.allOf((CompletableFuture[])languageServers.stream().map(ls -> ls.getTextDocumentService().definition(params).thenAcceptAsync(locations -> {
                    if (locations == null) {
                        return;
                    }
                    if (locations.isLeft()) {
                        allLinks.addAll(((List)locations.getLeft()).stream().filter(Objects::nonNull).map(location -> new LSBasedHyperlink((Location)location, linkRegion)).collect(Collectors.toList()));
                    } else {
                        allLinks.addAll(((List)locations.getRight()).stream().filter(Objects::nonNull).map(locationLink -> new LSBasedHyperlink((LocationLink)locationLink, linkRegion)).collect(Collectors.toList()));
                    }
                })).toArray(CompletableFuture[]::new)).thenApply(theVoid -> allLinks);
            })).get(500L, TimeUnit.MILLISECONDS);
            if (!res.isEmpty()) break block8;
            return null;
        }
        try {
            return res.toArray(new IHyperlink[res.size()]);
        }
        catch (ExecutionException | TimeoutException e) {
            LanguageServerPlugin.logError(e);
            return null;
        }
        catch (InterruptedException e) {
            LanguageServerPlugin.logError(e);
            Thread.currentThread().interrupt();
            return null;
        }
    }

    private IRegion findWord(IDocument document, int offset) {
        int start = -2;
        int end = -1;
        try {
            char c;
            int pos = offset;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (!Character.isUnicodeIdentifierPart(c)) break;
                --pos;
            }
            start = pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (!Character.isUnicodeIdentifierPart(c)) break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException x) {
            LanguageServerPlugin.logWarning(x.getMessage(), x);
        }
        if (start >= -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }
}

