/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jetty.deploy.ConfigurationManager;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.resource.Resource;

@ManagedObject(value="Configure deployed webapps via properties")
public class PropertiesConfigurationManager
implements ConfigurationManager {
    private String _properties;
    private final Map<String, String> _map = new HashMap<String, String>();

    public PropertiesConfigurationManager(String properties) {
    }

    public PropertiesConfigurationManager() {
    }

    @ManagedAttribute(value="A file or URL of properties")
    public void setFile(String resource) throws MalformedURLException, IOException {
        this._properties = resource;
        this._map.clear();
        this.loadProperties(this._properties);
    }

    public String getFile() {
        return this._properties;
    }

    @ManagedOperation(value="Set a property")
    public void put(@Name(value="name") String name, @Name(value="value") String value) {
        this._map.put(name, value);
    }

    @Override
    public Map<String, String> getProperties() {
        return new HashMap<String, String>(this._map);
    }

    private void loadProperties(String resource) throws FileNotFoundException, IOException {
        Resource file = Resource.newResource((String)resource);
        if (file != null && file.exists()) {
            Properties properties = new Properties();
            properties.load(file.getInputStream());
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this._map.put(entry.getKey().toString(), String.valueOf(entry.getValue()));
            }
        }
    }
}

