/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers;

import java.util.ArrayList;
import org.eclipse.jface.viewers.TreePath;

public class ModelNode {
    private Object fElement;
    private boolean fIsContainer;
    private ModelNode fParent;
    private ModelNode[] fChildren;
    private boolean fDisposed;

    public ModelNode(ModelNode parent, Object element) {
        this.fParent = parent;
        this.fElement = element;
    }

    public synchronized Object getElement() {
        return this.fElement;
    }

    public synchronized void remap(Object element) {
        this.fElement = element;
    }

    public ModelNode getParentNode() {
        return this.fParent;
    }

    public synchronized boolean isContainer() {
        return this.fIsContainer;
    }

    public synchronized ModelNode[] getChildrenNodes() {
        return this.fChildren;
    }

    public synchronized boolean isDisposed() {
        return this.fDisposed;
    }

    public synchronized void dispose() {
        this.fDisposed = true;
        ModelNode[] childrenNodes = this.getChildrenNodes();
        if (childrenNodes != null) {
            int i = 0;
            while (i < childrenNodes.length) {
                childrenNodes[i].dispose();
                ++i;
            }
        }
    }

    public synchronized boolean correspondsTo(TreePath path) {
        int index = path.getSegmentCount() - 1;
        for (ModelNode node = this; index >= 0 && node != null; --index, node = node.getParentNode()) {
            Object pathElement = path.getSegment(index);
            if (pathElement.equals(node.getElement())) {
                continue;
            }
            return false;
        }
        return index == -1;
    }

    public synchronized TreePath getTreePath() {
        ArrayList<Object> path = new ArrayList<Object>();
        ModelNode node = this;
        while (node != null) {
            path.add(0, node.getElement());
            node = node.getParentNode();
        }
        return new TreePath(path.toArray());
    }

    public synchronized void addChild(ModelNode child) {
        if (this.fChildren == null) {
            this.fChildren = new ModelNode[]{child};
        } else {
            ModelNode[] kids = new ModelNode[this.fChildren.length + 1];
            System.arraycopy(this.fChildren, 0, kids, 0, this.fChildren.length);
            kids[this.fChildren.length] = child;
            this.fChildren = kids;
        }
    }

    public synchronized void removeChild(ModelNode child) {
        if (this.fChildren != null) {
            int i = 0;
            while (i < this.fChildren.length) {
                ModelNode kid = this.fChildren[i];
                if (child == kid) {
                    ModelNode[] newNodes = new ModelNode[this.fChildren.length - 1];
                    System.arraycopy(this.fChildren, 0, newNodes, 0, i);
                    if (i < newNodes.length) {
                        System.arraycopy(this.fChildren, i + 1, newNodes, i, newNodes.length - i);
                    }
                    this.fChildren = newNodes;
                    return;
                }
                ++i;
            }
        }
    }

    public synchronized void setChildren(ModelNode[] children) {
        if (children != null && children.length == 0) {
            this.fChildren = null;
            this.setIsContainer(false);
        } else {
            this.fChildren = children;
        }
    }

    public synchronized int getChildCount() {
        if (this.fChildren == null) {
            if (this.isContainer()) {
                return 1;
            }
            return 0;
        }
        return this.fChildren.length;
    }

    public synchronized int getChildIndex(ModelNode child) {
        if (this.fChildren != null) {
            int i = 0;
            while (i < this.fChildren.length) {
                if (child == this.fChildren[i]) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public synchronized void setIsContainer(boolean container) {
        this.fIsContainer = container;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.isDisposed()) {
            buf.append("[DISPOSED] ");
        }
        if (this.isContainer()) {
            buf.append("[+] ");
        }
        buf.append(this.getElement());
        return buf.toString();
    }
}

