/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTAliasDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTypeId;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTAttributeOwner;

public class CPPASTAliasDeclaration
extends CPPASTAttributeOwner
implements ICPPASTAliasDeclaration {
    private IASTName aliasName;
    private ICPPASTTypeId mappingTypeId;

    public CPPASTAliasDeclaration(IASTName aliasName, ICPPASTTypeId mappingTypeId) {
        this.setAlias(aliasName);
        this.setMappingTypeId(mappingTypeId);
    }

    @Override
    public int getRoleForName(IASTName name) {
        if (this.aliasName == name) {
            return 2;
        }
        if (this.mappingTypeId == name) {
            return 1;
        }
        return 3;
    }

    @Override
    public IASTName getAlias() {
        return this.aliasName;
    }

    @Override
    public void setAlias(IASTName aliasName) {
        this.assertNotFrozen();
        this.aliasName = aliasName;
        if (aliasName != null) {
            aliasName.setParent(this);
            aliasName.setPropertyInParent(ALIAS_NAME);
        }
    }

    @Override
    public ICPPASTTypeId getMappingTypeId() {
        return this.mappingTypeId;
    }

    @Override
    public void setMappingTypeId(ICPPASTTypeId mappingTypeId) {
        this.assertNotFrozen();
        this.mappingTypeId = mappingTypeId;
        if (mappingTypeId != null) {
            mappingTypeId.setParent(this);
            mappingTypeId.setPropertyInParent(TARGET_TYPEID);
        }
    }

    @Override
    public ICPPASTAliasDeclaration copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public ICPPASTAliasDeclaration copy(IASTNode.CopyStyle style) {
        CPPASTAliasDeclaration copy = new CPPASTAliasDeclaration(this.aliasName == null ? null : this.aliasName.copy(style), this.mappingTypeId == null ? null : this.mappingTypeId.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclarations) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.aliasName != null && !this.aliasName.accept(action)) {
            return false;
        }
        if (!this.acceptByAttributeSpecifiers(action)) {
            return false;
        }
        if (this.mappingTypeId != null && !this.mappingTypeId.accept(action)) {
            return false;
        }
        if (action.shouldVisitDeclarations) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }
}

