/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import java.util.Stack;
import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.SemanticQueries;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;

public class VirtualMethodCallChecker
extends AbstractIndexAstChecker {
    public static final String VIRTUAL_CALL_ID = "org.eclipse.cdt.codan.internal.checkers.VirtualMethodCallProblem";

    public void processAst(IASTTranslationUnit ast) {
        ast.accept((ASTVisitor)new OnEachClass());
    }

    class OnEachClass
    extends ASTVisitor {
        private final Stack<Boolean> ctorDtorStack = new Stack();

        OnEachClass() {
            this.shouldVisitDeclarations = true;
            this.shouldVisitExpressions = true;
            this.shouldVisitDeclSpecifiers = true;
        }

        public int visit(IASTDeclSpecifier declSpec) {
            if (declSpec instanceof ICPPASTCompositeTypeSpecifier && !this.ctorDtorStack.isEmpty()) {
                this.ctorDtorStack.push(false);
            }
            return 3;
        }

        public int leave(IASTDeclSpecifier declSpec) {
            if (declSpec instanceof ICPPASTCompositeTypeSpecifier && !this.ctorDtorStack.isEmpty()) {
                this.ctorDtorStack.pop();
            }
            return 3;
        }

        public int visit(IASTDeclaration declaration) {
            ICPPConstructor constructor = this.getConstructor(declaration);
            if (constructor != null) {
                this.ctorDtorStack.push(true);
            } else {
                ICPPMethod destructor = this.getDestructor(declaration);
                if (destructor != null) {
                    this.ctorDtorStack.push(true);
                }
            }
            return 3;
        }

        public int leave(IASTDeclaration declaration) {
            if (this.getConstructor(declaration) != null || this.getDestructor(declaration) != null) {
                this.ctorDtorStack.pop();
            }
            return 3;
        }

        public int visit(IASTExpression expression) {
            if (!this.ctorDtorStack.empty() && this.ctorDtorStack.peek().booleanValue() && expression instanceof IASTFunctionCallExpression) {
                ICPPMethod method;
                IASTIdExpression fName;
                IASTFunctionCallExpression fCall = (IASTFunctionCallExpression)expression;
                IASTExpression fNameExp = fCall.getFunctionNameExpression();
                IBinding fBinding = null;
                IASTExpression problemNode = expression;
                if (fNameExp instanceof IASTIdExpression) {
                    fName = (IASTIdExpression)fNameExp;
                    fBinding = fName.getName().resolveBinding();
                } else if (fNameExp instanceof IASTFieldReference) {
                    fName = (IASTFieldReference)fNameExp;
                    problemNode = fName.getFieldName();
                    if (this.referencesThis((IASTNode)fName.getFieldOwner())) {
                        fBinding = fName.getFieldName().resolveBinding();
                    }
                }
                if (fBinding instanceof ICPPMethod && ((method = (ICPPMethod)fBinding).isPureVirtual() || ClassTypeHelper.isVirtual((ICPPMethod)method))) {
                    VirtualMethodCallChecker.this.reportProblem(VirtualMethodCallChecker.VIRTUAL_CALL_ID, (IASTNode)problemNode, new Object[0]);
                }
            }
            return 3;
        }

        private ICPPConstructor getConstructor(IASTDeclaration decl) {
            if (decl instanceof ICPPASTFunctionDefinition) {
                ICPPASTFunctionDefinition functionDefinition = (ICPPASTFunctionDefinition)decl;
                if (functionDefinition.isDeleted()) {
                    return null;
                }
                IBinding binding = functionDefinition.getDeclarator().getName().resolveBinding();
                if (binding instanceof ICPPConstructor) {
                    ICPPConstructor constructor = (ICPPConstructor)binding;
                    if (functionDefinition.isDefaulted() && SemanticQueries.isCopyOrMoveConstructor((ICPPConstructor)constructor)) {
                        return null;
                    }
                    if (constructor.getClassOwner().getKey() == 2) {
                        return null;
                    }
                    ICPPASTConstructorChainInitializer[] iCPPASTConstructorChainInitializerArray = functionDefinition.getMemberInitializers();
                    int n = iCPPASTConstructorChainInitializerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICPPASTConstructorChainInitializer memberInitializer = iCPPASTConstructorChainInitializerArray[n2];
                        IASTName memberName = memberInitializer.getMemberInitializerId();
                        if (memberName != null) {
                            IBinding memberBinding = memberName.resolveBinding();
                            ICPPClassType classType = null;
                            if (memberBinding instanceof ICPPConstructor) {
                                classType = ((ICPPConstructor)memberBinding).getClassOwner();
                            }
                            if (classType instanceof ICPPDeferredClassInstance) {
                                classType = ((ICPPDeferredClassInstance)classType).getClassTemplate();
                            }
                            if (classType != null && classType.isSameType((IType)constructor.getClassOwner())) {
                                return null;
                            }
                        }
                        ++n2;
                    }
                    return constructor;
                }
            }
            return null;
        }

        private boolean referencesThis(IASTNode expr) {
            if (expr instanceof IASTLiteralExpression) {
                IASTLiteralExpression litArg = (IASTLiteralExpression)expr;
                if (litArg.getKind() == 4) {
                    return true;
                }
            } else if (expr instanceof ICPPASTUnaryExpression) {
                ICPPASTUnaryExpression unExpr = (ICPPASTUnaryExpression)expr;
                switch (unExpr.getOperator()) {
                    case 4: 
                    case 5: 
                    case 11: {
                        return this.referencesThis((IASTNode)unExpr.getOperand());
                    }
                }
            }
            return false;
        }

        private ICPPMethod getDestructor(IASTDeclaration decl) {
            if (decl instanceof ICPPASTFunctionDefinition) {
                ICPPMethod method;
                ICPPASTFunctionDefinition functionDefinition = (ICPPASTFunctionDefinition)decl;
                if (functionDefinition.isDeleted()) {
                    return null;
                }
                IBinding binding = functionDefinition.getDeclarator().getName().resolveBinding();
                if (binding instanceof ICPPMethod && (method = (ICPPMethod)binding).isDestructor()) {
                    return method;
                }
            }
            return null;
        }
    }
}

