/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage;

import com.google.common.base.Joiner;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage.CpuUsageView;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage.Messages;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectedCpuQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.presentation.IYAppearance;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfFilteredXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfXYChartSettings;
import org.swtchart.ITitle;

public class CpuUsageXYViewer
extends TmfFilteredXYChartViewer {
    private static final int DEFAULT_SERIES_WIDTH = 1;

    public CpuUsageXYViewer(Composite parent, TmfXYChartSettings settings) {
        super(parent, settings, "org.eclipse.tracecompass.analysis.os.linux.core.cpuusage.CpuUsageDataProvider");
        this.getSwtChart().getTitle().setVisible(true);
        this.getSwtChart().getLegend().setVisible(false);
    }

    protected TimeQueryFilter createQueryFilter(long start, long end, int nb) {
        return new SelectedCpuQueryFilter(start, end, nb, this.getSelected(), CpuUsageView.getCpus(this.getTrace()));
    }

    public IYAppearance getSeriesAppearance(@NonNull String seriesName) {
        if (seriesName.startsWith("total:")) {
            return this.getPresentationProvider().getAppearance(seriesName, "line", 1);
        }
        return this.getPresentationProvider().getAppearance(seriesName, "area", 1);
    }

    protected void setTitle() {
        ITitle title = this.getSwtChart().getTitle();
        Set<Integer> cpus = CpuUsageView.getCpus(this.getTrace());
        if (cpus.isEmpty()) {
            title.setText(Messages.CpuUsageView_Title);
        } else {
            title.setText(String.valueOf(Messages.CpuUsageView_Title) + ' ' + Joiner.on((String)", ").join(cpus));
        }
    }
}

