/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.ide.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tips.core.ITipManager;
import org.eclipse.tips.core.internal.LogUtil;
import org.eclipse.tips.ide.internal.Messages;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class TipSourceProvider
extends AbstractSourceProvider {
    private boolean fNewTips;
    private ITipManager fManager;

    public TipSourceProvider(ITipManager manager) {
        this.fManager = manager;
    }

    public void dispose() {
    }

    public Map<?, ?> getCurrentState() {
        HashMap<String, Boolean> currentState = new HashMap<String, Boolean>();
        currentState.put("newtips", this.fNewTips);
        return currentState;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{"newtips"};
    }

    public synchronized void setStatus(boolean newTips) {
        boolean changed = this.fNewTips ^ newTips;
        if (changed) {
            this.fNewTips = newTips;
        }
        this.layoutWorkbench(changed);
    }

    private void layoutWorkbench(final boolean changed) {
        UIJob job = new UIJob(PlatformUI.getWorkbench().getDisplay(), Messages.TipSourceProvider_0){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (changed) {
                    TipSourceProvider.this.fireSourceChanged(16384, TipSourceProvider.this.getCurrentState());
                }
                IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
                int n = iWorkbenchWindowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    TipSourceProvider.this.fManager.log(LogUtil.info((String)(String.valueOf(Messages.TipSourceProvider_1) + window + " -> " + TipSourceProvider.this.fNewTips)));
                    window.getShell().layout(true, true);
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule(5000L);
    }
}

