/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.manager;

import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.manager.IPDITaskManager;
import org.eclipse.ptp.internal.debug.core.pdi.manager.AbstractPDIManager;

public class TaskManager
extends AbstractPDIManager
implements IPDITaskManager {
    private TaskSet terminatedTasks;
    private TaskSet suspendedTasks;
    private TaskSet registeredTasks;
    private TaskSet pendingTasks;
    private TaskSet canStepReturnTasks;

    public TaskManager(IPDISession session) {
        super(session, false);
        this.terminatedTasks = new TaskSet(session.getTotalTasks());
        this.suspendedTasks = new TaskSet(session.getTotalTasks());
        this.registeredTasks = new TaskSet(session.getTotalTasks());
        this.pendingTasks = new TaskSet(session.getTotalTasks());
        this.canStepReturnTasks = new TaskSet(session.getTotalTasks());
    }

    @Override
    public boolean canAllStepReturn(TaskSet tasks) {
        return this.getCannotStepReturnTasks(tasks.copy()).isEmpty();
    }

    @Override
    public TaskSet getCannotStepReturnTasks(TaskSet tasks) {
        tasks.andNot(this.getCanStepReturnTasks());
        return tasks;
    }

    @Override
    public TaskSet getCanStepReturnTasks() {
        return this.canStepReturnTasks;
    }

    @Override
    public TaskSet getCanStepReturnTasks(TaskSet tasks) {
        tasks.and(this.getCanStepReturnTasks());
        return tasks;
    }

    @Override
    public TaskSet getNonPendingTasks(TaskSet tasks) {
        tasks.andNot(this.getPendingTasks());
        return tasks;
    }

    @Override
    public TaskSet getNonRunningTasks(TaskSet tasks) {
        tasks.andNot(this.getRunningTasks(tasks.copy()));
        return tasks;
    }

    @Override
    public TaskSet getNonSuspendedTasks(TaskSet tasks) {
        tasks.andNot(this.getSuspendedTasks());
        return tasks;
    }

    @Override
    public TaskSet getNonTerminatedTasks(TaskSet tasks) {
        tasks.andNot(this.getTerminatedTasks());
        return tasks;
    }

    @Override
    public TaskSet getPendingTasks() {
        return this.pendingTasks;
    }

    @Override
    public TaskSet getPendingTasks(TaskSet tasks) {
        tasks.and(this.getPendingTasks());
        return tasks;
    }

    @Override
    public TaskSet getRegisteredTasks() {
        return this.registeredTasks;
    }

    @Override
    public TaskSet getRegisteredTasks(TaskSet tasks) {
        tasks.and(this.getRegisteredTasks());
        return tasks;
    }

    @Override
    public TaskSet getRunningTasks(TaskSet tasks) {
        tasks.andNot(this.getTerminatedTasks());
        tasks.andNot(this.getSuspendedTasks());
        return tasks;
    }

    @Override
    public TaskSet getSuspendedTasks() {
        return this.suspendedTasks;
    }

    @Override
    public TaskSet getSuspendedTasks(TaskSet tasks) {
        tasks.and(this.getSuspendedTasks());
        return tasks;
    }

    @Override
    public TaskSet getTerminatedTasks() {
        return this.terminatedTasks;
    }

    @Override
    public TaskSet getTerminatedTasks(TaskSet tasks) {
        tasks.and(this.getTerminatedTasks());
        return tasks;
    }

    @Override
    public TaskSet getUnregisteredTasks(TaskSet tasks) {
        tasks.andNot(this.getRegisteredTasks());
        return tasks;
    }

    @Override
    public boolean isAllPending(TaskSet tasks) {
        return this.getNonPendingTasks(tasks.copy()).isEmpty();
    }

    @Override
    public boolean isAllRegistered(TaskSet tasks) {
        return this.getUnregisteredTasks(tasks.copy()).isEmpty();
    }

    @Override
    public boolean isAllRunning(TaskSet tasks) {
        return !this.isAllSuspended(tasks) && !this.isAllTerminated(tasks);
    }

    @Override
    public boolean isAllSuspended(TaskSet tasks) {
        return this.getNonSuspendedTasks(tasks.copy()).isEmpty();
    }

    @Override
    public boolean isAllTerminated(TaskSet tasks) {
        return this.getNonTerminatedTasks(tasks.copy()).isEmpty();
    }

    @Override
    public void setCanStepReturnTasks(boolean isAdd, TaskSet tasks) {
        if (isAdd) {
            this.canStepReturnTasks = this.addTasks(this.canStepReturnTasks, tasks);
        } else {
            this.removeTasks(this.canStepReturnTasks, tasks);
        }
    }

    @Override
    public void setPendingTasks(boolean isAdd, TaskSet tasks) {
        if (isAdd) {
            this.pendingTasks = this.addTasks(this.pendingTasks, tasks);
        } else {
            this.removeTasks(this.pendingTasks, tasks);
        }
    }

    @Override
    public void setRegisterTasks(boolean isAdd, TaskSet tasks) {
        if (isAdd) {
            this.registeredTasks = this.addTasks(this.registeredTasks, tasks);
        } else {
            this.removeTasks(this.registeredTasks, tasks);
        }
    }

    @Override
    public void setSuspendTasks(boolean isAdd, TaskSet tasks) {
        if (isAdd) {
            this.suspendedTasks = this.addTasks(this.suspendedTasks, tasks);
        } else {
            this.removeTasks(this.suspendedTasks, tasks);
            this.setCanStepReturnTasks(false, tasks);
        }
    }

    @Override
    public void setTerminateTasks(boolean isAdd, TaskSet tasks) {
        if (isAdd) {
            this.terminatedTasks = this.addTasks(this.terminatedTasks, tasks);
            this.setSuspendTasks(false, tasks);
        } else {
            this.removeTasks(this.terminatedTasks, tasks);
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void update(TaskSet tasks) throws PDIException {
    }

    private synchronized TaskSet addTasks(TaskSet curTasks, TaskSet newTasks) {
        if (curTasks.taskSize() < newTasks.taskSize()) {
            newTasks.or(curTasks);
            curTasks = newTasks.copy();
        }
        curTasks.or(newTasks);
        return curTasks;
    }

    private synchronized void removeTasks(TaskSet curTasks, TaskSet newTasks) {
        curTasks.andNot(newTasks);
    }
}

