/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.ui.rename;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.core.ast.nodes.FormalParameter;
import org.eclipse.php.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.TypeDeclaration;
import org.eclipse.php.core.ast.nodes.Variable;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ASTNodeLabels {
    public static final int M_PARAMETER_TYPES = 1;
    public static final int M_PARAMETER_NAMES = 2;
    public static final int M_APP_RETURNTYPE = 8;
    public static final int M_PRE_RETURNTYPE = 16;
    public static final int M_FULLY_QUALIFIED = 32;
    public static final int M_POST_QUALIFIED = 64;
    public static final int I_POST_QUALIFIED = 256;
    public static final int F_APP_TYPE_SIGNATURE = 512;
    public static final int F_PRE_TYPE_SIGNATURE = 1024;
    public static final int F_FULLY_QUALIFIED = 2048;
    public static final int F_POST_QUALIFIED = 4096;
    public static final int T_FULLY_QUALIFIED = 8192;
    public static final int T_CONTAINER_QUALIFIED = 16384;
    public static final int T_POST_QUALIFIED = 32768;
    public static final int CU_QUALIFIED = 65536;
    public static final int CU_POST_QUALIFIED = 131072;
    public static final int P_QUALIFIED = 0x400000;
    public static final int P_POST_QUALIFIED = 0x800000;
    public static final int ROOT_VARIABLE = 0x1000000;
    public static final int ROOT_QUALIFIED = 0x2000000;
    public static final int ROOT_POST_QUALIFIED = 0x4000000;
    public static final int APPEND_ROOT_PATH = 0x8000000;
    public static final int PREPEND_ROOT_PATH = 0x10000000;
    public static final int P_COMPRESSED = 0x20000000;
    public static final int REFERENCED_ROOT_POST_QUALIFIED = 0x40000000;
    public static final long T_TYPE_PARAMETERS = 0x200000L;
    public static final long CF_POST_QUALIFIED = 0x10000000L;
    public static final long CF_QUALIFIED = 0x8000000L;
    public static final long I_FULLY_QUALIFIED = 1024L;
    public static final long D_QUALIFIED = 0x1000000L;
    public static final long D_POST_QUALIFIED = 0x2000000L;
    public static final int ALL_FULLY_QUALIFIED = 37824544;
    public static final int ALL_POST_QUALIFIED = 75665728;
    public static final int ALL_DEFAULT = 1;
    public static final int DEFAULT_QUALIFIED = 75808;
    public static final int DEFAULT_POST_QUALIFIED = 168256;
    public static final String CONCAT_STRING = " - ";
    public static final String COMMA_STRING = ", ";
    public static final String DECL_STRING = " :";
    public static final String DEFAULT_FOLDER = "(source)";

    public static String getElementLabel(Object element, long flags) {
        StringBuilder buf = new StringBuilder(60);
        ASTNodeLabels.getElementLabel(element, flags, buf);
        return buf.toString();
    }

    public static void getElementLabel(Object element, long flags, StringBuilder buf) {
        if (element instanceof ASTNode) {
            ASTNodeLabels.printNodeLabel((ASTNode)element, flags, buf);
        }
    }

    private static void printNodeLabel(ASTNode node, long flags, StringBuilder buf) {
        int type = node.getType();
        switch (type) {
            case 29: {
                ASTNodeLabels.getFunctionLabel((FunctionDeclaration)node, flags, buf);
                break;
            }
            case 42: {
                ASTNodeLabels.getMethodLabel((MethodDeclaration)node, flags, buf);
                break;
            }
            case 25: {
                ASTNodeLabels.getFieldLabel((FieldsDeclaration)node, flags, buf);
                break;
            }
            case 12: 
            case 40: {
                ASTNodeLabels.getTypeLabel((TypeDeclaration)node, flags, buf);
                break;
            }
            case 46: {
                ASTNodeLabels.getProgramLabel((Program)node, flags, buf);
            }
        }
    }

    private static void getFunctionLabel(FunctionDeclaration declaration, long flags, StringBuilder buf) {
        buf.append(declaration.getFunctionName().getName());
        if (ASTNodeLabels.getFlag(flags, 3L)) {
            List parameters = declaration.formalParameters();
            buf.append('(');
            int nParams = parameters != null && ASTNodeLabels.getFlag(flags, 1L) ? parameters.size() : 0;
            int i = 0;
            while (i < nParams) {
                if (i > 0) {
                    buf.append(COMMA_STRING);
                    buf.append(" ");
                }
                if (parameters != null) {
                    if (ASTNodeLabels.getFlag(flags, 1L) && ((FormalParameter)parameters.get(i)).getParameterType() != null) {
                        String t = ((FormalParameter)parameters.get(i)).getParameterType().toString();
                        t = t == null ? "" : String.valueOf(t) + " ";
                        buf.append(t);
                    }
                    if (ASTNodeLabels.getFlag(flags, 2L)) {
                        buf.append("$" + ((FormalParameter)parameters.get(i)).getParameterNameIdentifier().getName());
                    }
                }
                ++i;
            }
            buf.append(')');
        }
    }

    private static boolean getFlag(long flags, long flag) {
        return (flags & flag) != 0L;
    }

    public static void getMethodLabel(MethodDeclaration method, long flags, StringBuilder buf) {
        if (ASTNodeLabels.getFlag(flags, 32L)) {
            ASTNode parent = method.getParent().getParent();
            assert (parent != null && (parent.getType() == 12 || parent.getType() == 40));
            TypeDeclaration typeDeclaration = (TypeDeclaration)parent;
            ASTNodeLabels.getTypeLabel(typeDeclaration, 0x2000L | flags & 0x20000000L, buf);
            buf.append('.');
        }
        ASTNodeLabels.getFunctionLabel(method.getFunction(), flags, buf);
        if (ASTNodeLabels.getFlag(flags, 64L)) {
            buf.append(CONCAT_STRING);
            ASTNode container = method.getParent().getParent();
            assert (container == null || container.getType() == 12 || container.getType() == 40);
            TypeDeclaration declaration = (TypeDeclaration)container;
            if (declaration != null) {
                ASTNodeLabels.getTypeLabel(declaration, 0x2000L | flags & 0x20000000L, buf);
            }
        }
    }

    public static void getTypeLabel(TypeDeclaration type, long flags, StringBuilder buf) {
        if (type == null) {
            return;
        }
        String typeName = type.getName().getName();
        buf.append(typeName);
    }

    public static void getFieldLabel(FieldsDeclaration field, long flags, StringBuilder buf) {
        Variable[] variableNames = field.getVariableNames();
        int i = 0;
        while (i < variableNames.length) {
            Variable variable = variableNames[i];
            assert (variable.getName() instanceof Identifier);
            Identifier identifier = (Identifier)variable.getName();
            buf.append(identifier.getName());
            buf.append(" ,");
            ++i;
        }
        if (ASTNodeLabels.getFlag(flags, 4096L)) {
            buf.append(CONCAT_STRING);
            ASTNode container = field.getParent().getParent();
            assert (container == null || container.getType() == 12 || container.getType() == 40);
            TypeDeclaration declaration = (TypeDeclaration)container;
            if (declaration != null) {
                ASTNodeLabels.getTypeLabel(declaration, 0x2000L | flags & 0x20000000L, buf);
            }
        }
    }

    public static void getProgramLabel(Program program, long flags, StringBuilder buf) {
        buf.append("Program");
    }

    public static String getElementTooltipText(Object element) {
        StringBuilder buf = new StringBuilder(60);
        if (element instanceof ASTNode) {
            ASTNode node = (ASTNode)element;
            switch (node.getType()) {
                case 42: {
                    ASTNodeLabels.getMethodTooltipText(((MethodDeclaration)element).getFunction(), buf);
                    break;
                }
            }
        }
        return buf.toString();
    }

    public static void getMethodTooltipText(FunctionDeclaration function, StringBuilder buf) {
        buf.append(function.getFunctionName().getName());
        buf.append('(');
        List parameters = function.formalParameters();
        int i = 0;
        while (i < parameters.size()) {
            if (i > 0) {
                buf.append(COMMA_STRING);
            }
            buf.append(((FormalParameter)parameters.get(i)).getParameterType().toString());
            buf.append(" $" + ((FormalParameter)parameters.get(i)).getParameterNameIdentifier().getName());
            ++i;
        }
        buf.append(')');
    }

    public static String getTextLabel(Object obj, long flags) {
        IWorkbenchAdapter wbadapter;
        if (obj instanceof ASTNode) {
            return ASTNodeLabels.getElementLabel(obj, flags);
        }
        if (obj instanceof IAdaptable && (wbadapter = (IWorkbenchAdapter)((IAdaptable)obj).getAdapter(IWorkbenchAdapter.class)) != null) {
            return wbadapter.getLabel(obj);
        }
        return "";
    }

    public static String getTooltipTextLabel(Object obj) {
        IWorkbenchAdapter wbadapter;
        if (obj instanceof ASTNode) {
            return ASTNodeLabels.getElementTooltipText(obj);
        }
        if (obj instanceof IAdaptable && (wbadapter = (IWorkbenchAdapter)((IAdaptable)obj).getAdapter(IWorkbenchAdapter.class)) != null) {
            return wbadapter.getLabel(obj);
        }
        return "";
    }
}

