/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phar;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.php.internal.core.phar.AbstractFileExporter;
import org.eclipse.php.internal.core.phar.IStub;
import org.eclipse.php.internal.core.phar.PharAchiveOutputEntry;
import org.eclipse.php.internal.core.phar.PharBufferedOutputStream;
import org.eclipse.php.internal.core.phar.PharPackage;

public class PharFileExporter
extends AbstractFileExporter {
    PharBufferedOutputStream outputStream;
    Set<File> exportedField;

    public PharFileExporter(PharPackage pharPackage) throws IOException {
        super(pharPackage);
        this.outputStream = new PharBufferedOutputStream(this.fileContentStream, pharPackage);
        this.exportedField = new HashSet<File>();
    }

    @Override
    public void finished() throws IOException {
        this.outputStream.close();
    }

    @Override
    public void write(IFile resource, String destinationPath) throws IOException, CoreException {
        this.write(resource.getLocation().toFile(), destinationPath);
    }

    public void write(File file, String destinationPath) throws IOException, CoreException {
        PharAchiveOutputEntry newEntry = new PharAchiveOutputEntry(destinationPath);
        newEntry.setMethod(this.pharPackage.getCompressType());
        if (file.lastModified() != -1L) {
            newEntry.setTime(file.lastModified() / 1000L);
        }
        this.write(newEntry, file);
    }

    private void write(PharAchiveOutputEntry entry, File file) throws IOException, CoreException {
        if (this.exportedField.contains(file)) {
            return;
        }
        this.exportedField.add(file);
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        BufferedInputStream contentStream = new BufferedInputStream(new FileInputStream(file));
        entry.setSize(file.length());
        this.outputStream.putNextEntry(entry);
        try {
            int n;
            byte[] readBuffer = new byte[4096];
            while ((n = ((InputStream)contentStream).read(readBuffer)) > 0) {
                this.outputStream.write(readBuffer, 0, n);
            }
        }
        finally {
            if (contentStream != null) {
                ((InputStream)contentStream).close();
            }
        }
        this.outputStream.closeEntry();
    }

    @Override
    public void writeStub(IStub stub) throws IOException, CoreException {
        this.outputStream.writeStub(stub);
    }

    @Override
    public void write(IFolder resource, String destinationPath) throws IOException, CoreException {
        this.write(resource.getLocation().toFile(), destinationPath);
    }

    @Override
    public void writeSignature() throws IOException {
        this.outputStream.writeSignature();
    }

    @Override
    public void doWriteSignature() throws IOException {
    }
}

