/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.preprocessor.c;

import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.photran.internal.core.preprocessor.c.ASTFileLocation;
import org.eclipse.photran.internal.core.preprocessor.c.ASTImageLocation;
import org.eclipse.photran.internal.core.preprocessor.c.LocationMap;
import org.eclipse.photran.internal.core.preprocessor.c.ObjectStyleMacro;

public abstract class ImageLocationInfo {
    public static final ImageLocationInfo[] NO_LOCATION_INFOS = new ImageLocationInfo[0];
    int fTokenOffsetInExpansion = -1;

    public abstract IASTImageLocation createLocation(LocationMap var1, ImageLocationInfo var2);

    public abstract boolean canConcatenate(ImageLocationInfo var1);

    public static class MacroImageLocationInfo
    extends ImageLocationInfo {
        private final ObjectStyleMacro fMacro;
        private final int fOffset;
        private final int fEndOffset;

        public MacroImageLocationInfo(ObjectStyleMacro macro, int offset, int endOffset) {
            this.fMacro = macro;
            this.fOffset = offset;
            this.fEndOffset = endOffset;
        }

        @Override
        @Deprecated
        public IASTImageLocation createLocation(LocationMap lm, ImageLocationInfo upto) {
            return null;
        }

        @Override
        public boolean canConcatenate(ImageLocationInfo info) {
            if (info instanceof MacroImageLocationInfo) {
                MacroImageLocationInfo mli = (MacroImageLocationInfo)info;
                if (mli.fMacro == this.fMacro && this.fEndOffset <= mli.fOffset) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class ParameterImageLocationInfo
    extends ImageLocationInfo {
        public int fSequenceNumber;
        public int fSequenceEndNumber;

        public ParameterImageLocationInfo(int sequenceNumber, int sequenceEndNumber) {
            this.fSequenceNumber = sequenceNumber;
            this.fSequenceEndNumber = sequenceEndNumber;
        }

        @Override
        public IASTImageLocation createLocation(LocationMap lm, ImageLocationInfo upto) {
            int sequenceEnd = ((ParameterImageLocationInfo)upto).fSequenceEndNumber;
            ASTFileLocation loc = lm.getMappedFileLocation(this.fSequenceNumber, sequenceEnd - this.fSequenceNumber);
            if (loc != null) {
                return new ASTImageLocation(3, loc.getFileName(), loc.getNodeOffset(), loc.getNodeLength());
            }
            return null;
        }

        @Override
        public boolean canConcatenate(ImageLocationInfo info) {
            if (info instanceof ParameterImageLocationInfo) {
                ParameterImageLocationInfo pli = (ParameterImageLocationInfo)info;
                if (this.fSequenceEndNumber <= pli.fSequenceNumber) {
                    return true;
                }
            }
            return false;
        }
    }
}

