/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml.mojo;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.editor.xml.mojo.MojoParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlexusConfigHelper {
    private static final Logger log = LoggerFactory.getLogger(PlexusConfigHelper.class);
    private Map<Class<?>, List<MojoParameter>> processedClasses = new HashMap();
    private static final Set<String> INLINE_TYPES = ImmutableSet.of((Object)Byte.TYPE.getName(), (Object)Byte.class.getName(), (Object)Short.TYPE.getName(), (Object)Short.class.getName(), (Object)Integer.TYPE.getName(), (Object)Integer.class.getName(), (Object[])new String[]{Long.TYPE.getName(), Long.class.getName(), Float.TYPE.getName(), Float.class.getName(), Double.TYPE.getName(), Double.class.getName(), Boolean.TYPE.getName(), Boolean.class.getName(), Character.TYPE.getName(), Character.class.getName(), String.class.getName(), StringBuilder.class.getName(), StringBuffer.class.getName(), File.class.getName(), URI.class.getName(), URL.class.getName(), Date.class.getName(), "org.codehaus.plexus.configuration.PlexusConfiguration"});

    public List<MojoParameter> loadParameters(ClassRealm realm, Class<?> paramClass, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        List<MojoParameter> parameters = this.processedClasses.get(paramClass);
        if (parameters == null) {
            parameters = new ArrayList<MojoParameter>();
            this.processedClasses.put(paramClass, parameters);
            log.debug("Loading properties of {}", (Object)paramClass.getName());
            Map<String, Type> properties = this.getClassProperties(paramClass);
            for (Map.Entry<String, Type> e : properties.entrySet()) {
                if (monitor.isCanceled()) continue;
                this.addParameter(realm, paramClass, e.getValue(), e.getKey(), null, parameters, false, null, null, null, monitor);
            }
        }
        return parameters;
    }

    public void addParameter(ClassRealm realm, Class<?> enclosingClass, Type paramType, String name, String alias, List<MojoParameter> parameters, boolean required, String expression, String description, String defaultValue, IProgressMonitor monitor) throws CoreException {
        Type itemType;
        Class<?> paramClass = PlexusConfigHelper.getRawType(paramType);
        if (paramClass == null) {
            return;
        }
        if (PlexusConfigHelper.isInline(paramClass)) {
            parameters.add(PlexusConfigHelper.configure(new MojoParameter(name, PlexusConfigHelper.getTypeDisplayName(paramType)), required, expression, description, defaultValue));
            if (alias != null) {
                parameters.add(PlexusConfigHelper.configure(new MojoParameter(alias, PlexusConfigHelper.getTypeDisplayName(paramType)), required, expression, description, defaultValue));
            }
            return;
        }
        if (Map.class.isAssignableFrom(paramClass)) {
            parameters.add(PlexusConfigHelper.configure(new MojoParameter(name, PlexusConfigHelper.getTypeDisplayName(paramType)).map(), required, expression, description, defaultValue));
            if (alias != null) {
                parameters.add(PlexusConfigHelper.configure(new MojoParameter(alias, PlexusConfigHelper.getTypeDisplayName(paramType)).map(), required, expression, description, defaultValue));
            }
            return;
        }
        if (Properties.class.isAssignableFrom(paramClass)) {
            MojoParameter nested = new MojoParameter("property", "property", Arrays.asList(new MojoParameter("name", "String"), new MojoParameter("value", "String")));
            parameters.add(PlexusConfigHelper.configure(new MojoParameter(name, PlexusConfigHelper.getTypeDisplayName(paramType), nested), required, expression, description, defaultValue));
            if (alias != null) {
                parameters.add(PlexusConfigHelper.configure(new MojoParameter(alias, PlexusConfigHelper.getTypeDisplayName(paramType), nested), required, expression, description, defaultValue));
            }
        }
        if ((itemType = PlexusConfigHelper.getItemType(paramType)) != null) {
            List<MojoParameter> nested = this.getItemParameters(realm, enclosingClass, name, itemType, monitor);
            parameters.add(PlexusConfigHelper.configure(new MojoParameter(name, PlexusConfigHelper.getTypeDisplayName(paramType), nested), required, expression, description, defaultValue));
            if (alias != null) {
                nested = this.getItemParameters(realm, enclosingClass, alias, itemType, monitor);
                parameters.add(PlexusConfigHelper.configure(new MojoParameter(alias, PlexusConfigHelper.getTypeDisplayName(paramType), nested), required, expression, description, defaultValue));
            }
            return;
        }
        try {
            paramClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            return;
        }
        List<MojoParameter> nested = this.loadParameters(realm, paramClass, monitor);
        parameters.add(PlexusConfigHelper.configure(new MojoParameter(name, PlexusConfigHelper.getTypeDisplayName(paramType), nested), required, expression, description, defaultValue));
        if (alias != null) {
            parameters.add(PlexusConfigHelper.configure(new MojoParameter(alias, PlexusConfigHelper.getTypeDisplayName(paramType), nested), required, expression, description, defaultValue));
        }
    }

    public List<MojoParameter> getItemParameters(ClassRealm realm, Class<?> enclosingClass, String name, Type paramType, IProgressMonitor monitor) throws CoreException {
        Class<?> paramClass = PlexusConfigHelper.getRawType(paramType);
        if (paramClass == null || PlexusConfigHelper.isInline(paramClass)) {
            MojoParameter container = new MojoParameter(this.toSingularName(name), PlexusConfigHelper.getTypeDisplayName(paramType)).multiple();
            return Collections.singletonList(container);
        }
        if (Map.class.isAssignableFrom(paramClass) || Properties.class.isAssignableFrom(paramClass)) {
            MojoParameter container = new MojoParameter(this.toSingularName(name), PlexusConfigHelper.getTypeDisplayName(paramType)).multiple().map();
            return Collections.singletonList(container);
        }
        Type itemType = PlexusConfigHelper.getItemType(paramType);
        if (itemType != null) {
            List<MojoParameter> nested = this.getItemParameters(realm, enclosingClass, name, itemType, monitor);
            MojoParameter container = new MojoParameter(this.toSingularName(name), PlexusConfigHelper.getTypeDisplayName(paramType), nested).multiple();
            return Collections.singletonList(container);
        }
        List<Class> parameterClasses = this.getCandidateClasses(realm, enclosingClass, paramClass);
        ArrayList<MojoParameter> parameters = new ArrayList<MojoParameter>();
        for (Class clazz : parameterClasses) {
            String paramName;
            if (clazz.equals(paramClass)) {
                paramName = this.toSingularName(name);
            } else {
                paramName = clazz.getSimpleName();
                paramName = String.valueOf(Character.toLowerCase(paramName.charAt(0))) + paramName.substring(1);
            }
            List<MojoParameter> nested = this.loadParameters(realm, paramClass, monitor);
            MojoParameter container = new MojoParameter(paramName, PlexusConfigHelper.getTypeDisplayName(clazz), nested).multiple();
            parameters.add(container);
        }
        return parameters;
    }

    public static MojoParameter configure(MojoParameter p, boolean required, String expression, String description, String defaultValue) {
        p.setRequired(required);
        p.setExpression(expression);
        p.setDescription(description);
        p.setDefaultValue(defaultValue);
        return p;
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return null;
    }

    public static Type getItemType(Type paramType) {
        ParameterizedType pt;
        Type[] args;
        Class<?> paramClass = PlexusConfigHelper.getRawType(paramType);
        if (paramClass != null && paramClass.isArray()) {
            return paramClass.getComponentType();
        }
        if (!Collection.class.isAssignableFrom(paramClass)) {
            return null;
        }
        if (paramType instanceof ParameterizedType && (args = (pt = (ParameterizedType)paramType).getActualTypeArguments()).length > 0) {
            return args[0];
        }
        return null;
    }

    public Map<String, Type> getClassProperties(Class<?> clazz) {
        String prop;
        HashMap<String, Type> props = new HashMap<String, Type>();
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            Method m = methodArray[n2];
            if ((m.getModifiers() & 8) == 0 && ((name = m.getName()).startsWith("add") || name.startsWith("set")) && m.getParameterTypes().length == 1 && !(prop = name.substring(3)).isEmpty() && !props.containsKey(prop = String.valueOf(Character.toLowerCase(prop.charAt(0))) + prop.substring(1))) {
                props.put(prop, m.getGenericParameterTypes()[0]);
            }
            ++n2;
        }
        Class<?> pClazz = clazz;
        while (pClazz != null && !pClazz.equals(Object.class)) {
            Field[] fieldArray = pClazz.getDeclaredFields();
            int n3 = fieldArray.length;
            n = 0;
            while (n < n3) {
                Field f = fieldArray[n];
                if ((f.getModifiers() & 0x18) == 0 && !props.containsKey(prop = f.getName())) {
                    props.put(prop, f.getGenericType());
                }
                ++n;
            }
            pClazz = pClazz.getSuperclass();
        }
        return props;
    }

    public List<Class> getCandidateClasses(ClassRealm realm, Class enclosingClass, Class paramClass) {
        String name = enclosingClass.getName();
        int dot = name.lastIndexOf(46);
        if (dot > 0) {
            ClassPath cp;
            String pkg = name.substring(0, dot);
            ArrayList<Class> candidateClasses = null;
            try {
                cp = ClassPath.from((ClassLoader)realm);
            }
            catch (IOException e) {
                log.error(e.getMessage());
                return Collections.singletonList(enclosingClass);
            }
            for (ClassPath.ClassInfo ci : cp.getTopLevelClasses(pkg)) {
                Class clazz;
                try {
                    clazz = realm.loadClass(ci.getName());
                }
                catch (ClassNotFoundException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    continue;
                }
                if ((clazz.getModifiers() & 0x400) != 0 || !paramClass.isAssignableFrom(clazz)) continue;
                try {
                    clazz.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException ex) {
                    continue;
                }
                if (candidateClasses == null) {
                    candidateClasses = new ArrayList<Class>();
                }
                candidateClasses.add(clazz);
            }
            if (candidateClasses != null) {
                return candidateClasses;
            }
        }
        return Collections.singletonList(paramClass);
    }

    public static boolean isInline(Class<?> paramClass) {
        return INLINE_TYPES.contains(paramClass.getName()) || paramClass.isEnum();
    }

    public static String getTypeDisplayName(Type type) {
        Class<?> clazz = PlexusConfigHelper.getRawType(type);
        if (clazz == null) {
            return type.toString();
        }
        if (clazz.isArray()) {
            return String.valueOf(PlexusConfigHelper.getTypeDisplayName(clazz.getComponentType())) + "[]";
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            StringBuilder sb = new StringBuilder();
            sb.append(PlexusConfigHelper.getTypeDisplayName(clazz)).append("&lt;");
            boolean first = true;
            Type[] typeArray = ptype.getActualTypeArguments();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type arg = typeArray[n2];
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(PlexusConfigHelper.getTypeDisplayName(arg));
                ++n2;
            }
            return sb.append("&gt;").toString();
        }
        String name = clazz.getName();
        int idx = name.lastIndexOf(46);
        if (idx == -1) {
            return name;
        }
        String pkg = name.substring(0, idx);
        if (pkg.equals("java.lang") || pkg.equals("java.util") || pkg.equals("java.io")) {
            return clazz.getSimpleName();
        }
        return name;
    }

    public String toSingularName(String name) {
        if (name == null || name.trim().isEmpty()) {
            return name;
        }
        if (name.endsWith("ies")) {
            return String.valueOf(name.substring(0, name.length() - 3)) + "y";
        }
        if (name.endsWith("ches")) {
            return name.substring(0, name.length() - 2);
        }
        if (name.endsWith("xes")) {
            return name.substring(0, name.length() - 2);
        }
        if (name.endsWith("s") && name.length() != 1) {
            return name.substring(0, name.length() - 1);
        }
        return name;
    }
}

