/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.knopflerfish;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.libra.framework.core.FrameworkDelegate;
import org.eclipse.libra.framework.core.IOSGIFrameworkWorkingCopy;
import org.eclipse.libra.framework.knopflerfish.IKnopflerfishFramework;
import org.eclipse.libra.framework.knopflerfish.IKnopflerfishVersionHandler;
import org.eclipse.libra.framework.knopflerfish.KnopflerfishPlugin;
import org.eclipse.libra.framework.knopflerfish.Messages;
import org.eclipse.wst.server.core.IRuntimeType;

public class KnopflerfishFramework
extends FrameworkDelegate
implements IOSGIFrameworkWorkingCopy,
IKnopflerfishFramework {
    public IKnopflerfishVersionHandler getVersionHandler() {
        IRuntimeType type = this.getRuntime().getRuntimeType();
        return KnopflerfishPlugin.getFelixVersionHandler(type.getId());
    }

    public List getFrameworkClasspath(IPath configPath) {
        IPath installPath = this.getRuntime().getLocation();
        if (!installPath.isAbsolute()) {
            try {
                String installLoc = new File(installPath.toOSString()).getCanonicalPath();
                installPath = new Path(installLoc);
            }
            catch (IOException iOException) {}
        }
        return this.getVersionHandler().getFrameworkClasspath(installPath, configPath);
    }

    public IStatus verifyLocation() {
        return this.getVersionHandler().verifyInstallPath(this.getRuntime().getLocation());
    }

    public IStatus validate() {
        File[] bundle;
        IStatus status = super.validate();
        if (!status.isOK()) {
            return status;
        }
        status = this.verifyLocation();
        if (!status.isOK()) {
            return status;
        }
        if (this.getRuntime().getLocation().hasTrailingSeparator()) {
            return new Status(4, "org.eclipse.libra.framework.knopflerfish", 0, Messages.errorInstallDirTrailingSlash, null);
        }
        if (this.getVMInstall() == null) {
            return new Status(4, "org.eclipse.libra.framework.knopflerfish", 0, Messages.errorJRE, null);
        }
        File f = this.getRuntime().getLocation().append("conf").toFile();
        File[] conf = f.listFiles();
        if (conf != null) {
            int size = conf.length;
            int i = 0;
            while (i < size) {
                if (!f.canRead()) {
                    return new Status(2, "org.eclipse.libra.framework.knopflerfish", 0, Messages.warningCantReadConfig, null);
                }
                ++i;
            }
        }
        if ((bundle = (f = this.getRuntime().getLocation().append("bundle").toFile()).listFiles()) != null) {
            int size = bundle.length;
            int i = 0;
            while (i < size) {
                if (!f.canRead()) {
                    return new Status(2, "org.eclipse.libra.framework.knopflerfish", 0, Messages.warningCantReadBundle, null);
                }
                ++i;
            }
        }
        return Status.OK_STATUS;
    }
}

