/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.internal.commands;

import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.communication.internal.APICommand;
import org.eclipse.jubula.communication.internal.message.CAPTestResponseMessage;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.tools.internal.utils.IsAliveThread;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAPTestResponseCommand
implements APICommand {
    private static final Logger LOG = LoggerFactory.getLogger(CAPTestResponseCommand.class);
    private CAPTestResponseMessage m_capTestResponseMessage;
    private MessageCap m_messageCap;

    public Message getMessage() {
        return this.m_capTestResponseMessage;
    }

    public void setMessage(Message message) {
        this.m_capTestResponseMessage = (CAPTestResponseMessage)message;
    }

    public Message execute() {
        this.logResult();
        IsAliveThread t = new IsAliveThread("Execute Test Step"){

            public void run() {
                TestExecution.getInstance().processServerResponseWrapper((CAPTestResponseMessage)CAPTestResponseCommand.this.getMessage());
            }
        };
        t.start();
        return null;
    }

    public void timeout() {
        StringBuilder messageCapData = new StringBuilder(";");
        messageCapData.append(Messages.MessageCap);
        messageCapData.append(":");
        messageCapData.append(" ");
        if (LOG.isErrorEnabled()) {
            if (this.m_capTestResponseMessage != null) {
                MessageCap msgCap = this.m_capTestResponseMessage.getMessageCap();
                messageCapData.append(Messages.Method).append("'").append(msgCap.getMethod()).append("'").append(",").append(" ").append(Messages.ComponentId).append(" ").append("'").append(msgCap.getCi()).append("'");
            } else {
                messageCapData.append(Messages.Null);
            }
        }
        LOG.error(String.valueOf(this.getClass().getName()) + " " + Messages.TimeoutCalled + messageCapData.toString());
        TestExecution.getInstance().timeout();
    }

    private void logResult() {
        if (LOG.isInfoEnabled()) {
            String message = String.valueOf(Messages.TestStepResult) + ":";
            int state = this.m_capTestResponseMessage.getState();
            switch (state) {
                case 0: {
                    message = String.valueOf(message) + Messages.Success;
                    if (Void.TYPE.getName().equals(this.m_capTestResponseMessage.getReturnType())) break;
                    message = String.valueOf(message) + "\n" + Messages.ReturnType + " " + this.m_capTestResponseMessage.getReturnType() + "\n" + Messages.ReturnValue + ":" + this.m_capTestResponseMessage.getReturnValue();
                    break;
                }
                case 1: {
                    message = String.valueOf(message) + Messages.GeneralFailure + "\n";
                    break;
                }
                case 2: {
                    message = String.valueOf(message) + NLS.bind((String)Messages.Failure, (Object)Messages.MissingPermission);
                    break;
                }
                case 3: {
                    message = String.valueOf(message) + NLS.bind((String)Messages.Failure, (Object)Messages.MethodNotAccesible);
                    break;
                }
                case 10: {
                    message = String.valueOf(message) + NLS.bind((String)Messages.Failure, (Object)Messages.MissingImplementationClass);
                    break;
                }
                case 11: {
                    break;
                }
                case 12: {
                    message = String.valueOf(message) + NLS.bind((String)Messages.Failure, (Object)Messages.parametersAreNotValid);
                    break;
                }
                case 13: {
                    message = String.valueOf(message) + NLS.bind((String)Messages.Failure, (Object)Messages.ImplementingMethodHasThrownAnException);
                    break;
                }
                case 20: {
                    message = String.valueOf(message) + NLS.bind((String)Messages.Failure, (Object)Messages.ComponentIsNotSupported);
                    break;
                }
                case 21: {
                    message = String.valueOf(message) + NLS.bind((String)Messages.Failure, (Object)Messages.ComponentNotFound);
                    break;
                }
                default: {
                    message = String.valueOf(Messages.UnknownState) + ":" + " " + state;
                }
            }
            LOG.debug(message);
        }
    }

    public MessageCap getMessageCap() {
        return this.m_messageCap;
    }

    public void setMessageCap(MessageCap messageCap) {
        this.m_messageCap = messageCap;
    }
}

