/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.List;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.utils.AbstractNonPostOperatingTreeNodeOperation;
import org.eclipse.jubula.client.core.utils.DependencyFinderOp;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;

public class DependencyCheckerOp
extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
    private DependencyFinderOp m_dependencyFinder;
    private String m_dependencyPath;

    public DependencyCheckerOp(INodePO node) {
        this.m_dependencyFinder = new DependencyFinderOp(node);
    }

    @Override
    public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
        if (this.hasDependency()) {
            ctx.setContinued(false);
            return true;
        }
        this.m_dependencyFinder.operate(ctx, parent, node, alreadyVisited);
        if (this.hasDependency()) {
            this.buildPathString(ctx.getCurrentTreePath());
        }
        return true;
    }

    private void buildPathString(List<INodePO> currentTreePath) {
        StringBuilder sb = new StringBuilder();
        for (INodePO node : currentTreePath) {
            sb.append("/");
            sb.append(node.getName());
        }
        this.m_dependencyPath = sb.toString();
    }

    public boolean hasDependency() {
        return !this.m_dependencyFinder.getDependentNodes().isEmpty();
    }

    public String getDependencyPath() {
        return this.m_dependencyPath;
    }
}

