/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.util.FS;
import org.kohsuke.args4j.Argument;

@Command(common=false, usage="usage_ServerSideBackendForJgitPush")
class ReceivePack
extends TextBuiltin {
    @Argument(index=0, required=true, metaVar="metaVar_directory", usage="usage_RepositoryToReceiveInto")
    File dstGitdir;

    ReceivePack() {
    }

    @Override
    protected final boolean requiresRepository() {
        return false;
    }

    @Override
    protected void run() {
        try {
            RepositoryCache.FileKey key = RepositoryCache.FileKey.lenient((File)this.dstGitdir, (FS)FS.DETECTED);
            this.db = key.open(true);
        }
        catch (RepositoryNotFoundException notFound) {
            throw ReceivePack.die(MessageFormat.format(CLIText.get().notAGitRepository, this.dstGitdir.getPath()));
        }
        catch (IOException e) {
            throw ReceivePack.die(e.getMessage(), (Throwable)e);
        }
        org.eclipse.jgit.transport.ReceivePack rp = new org.eclipse.jgit.transport.ReceivePack(this.db);
        try {
            rp.receive(this.ins, this.outs, this.errs);
        }
        catch (IOException e) {
            throw ReceivePack.die(e.getMessage(), (Throwable)e);
        }
    }
}

