/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.editors;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.eclemma.internal.ui.UIMessages;
import org.eclipse.eclemma.internal.ui.editors.AbstractExecutionDataContentProvider;
import org.eclipse.eclemma.internal.ui.editors.ExecutedClassesFilters;
import org.eclipse.eclemma.internal.ui.editors.ExecutionDataContent;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.progress.UIJob;
import org.jacoco.core.data.ExecutionData;

class ExecutedClassesPage
extends FormPage {
    private final ExecutionDataContent content;
    private final Job refreshJob;
    private TableViewer dataTableViewer;
    private Text filter;

    public ExecutedClassesPage(FormEditor parent, ExecutionDataContent content) {
        super(parent, "classes", UIMessages.ExecutionDataEditorExecutedClassesPage_title);
        this.content = content;
        this.refreshJob = new RefreshJob();
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        form.setText(UIMessages.ExecutionDataEditorExecutedClassesPage_title);
        toolkit.decorateFormHeading(form.getForm());
        Composite body = form.getBody();
        body.setLayout((Layout)new GridLayout(1, true));
        this.filter = toolkit.createText(body, null, 388);
        this.filter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExecutedClassesPage.this.triggerRefresh();
            }
        });
        this.filter.setMessage(UIMessages.ExecutionDataEditorExecutedClassesPageFilter_message);
        this.filter.setLayoutData((Object)new GridData(4, 0, true, false));
        Table dataTable = toolkit.createTable(body, 0x10010A00);
        dataTable.setHeaderVisible(true);
        dataTable.setLinesVisible(true);
        dataTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.dataTableViewer = new TableViewer(dataTable);
        TableViewerColumn classIdColumnViewer = new TableViewerColumn(this.dataTableViewer, 0);
        classIdColumnViewer.setLabelProvider((CellLabelProvider)new ClassIdLabelProvider());
        TableColumn classIdColumn = classIdColumnViewer.getColumn();
        classIdColumn.setText(UIMessages.ExecutionDataEditorExecutedClassesPageColumnId_label);
        classIdColumn.setWidth(200);
        classIdColumn.setResizable(true);
        TableViewerColumn vmNameColumnViewer = new TableViewerColumn(this.dataTableViewer, 0);
        vmNameColumnViewer.setLabelProvider((CellLabelProvider)new VMNameLabelProvider());
        TableColumn vmNameColumn = vmNameColumnViewer.getColumn();
        vmNameColumn.setText(UIMessages.ExecutionDataEditorExecutedClassesPageColumnName_label);
        vmNameColumn.setWidth(500);
        vmNameColumn.setResizable(true);
        TableViewerColumn totalProbesColumnViewer = new TableViewerColumn(this.dataTableViewer, 131072);
        totalProbesColumnViewer.setLabelProvider((CellLabelProvider)new TotalProbesLabelProvider());
        TableColumn totalProbesColumn = totalProbesColumnViewer.getColumn();
        totalProbesColumn.setText(UIMessages.ExecutionDataEditorExecutedClassesPageColumnTotalProbes_label);
        totalProbesColumn.setWidth(100);
        totalProbesColumn.setResizable(true);
        TableViewerColumn executedProbesColumnViewer = new TableViewerColumn(this.dataTableViewer, 131072);
        executedProbesColumnViewer.setLabelProvider((CellLabelProvider)new ExecutedProbesLabelProvider());
        TableColumn executedProbesColumn = executedProbesColumnViewer.getColumn();
        executedProbesColumn.setText(UIMessages.ExecutionDataEditorExecutedClassesPageColumnExecutedProbes_label);
        executedProbesColumn.setWidth(100);
        executedProbesColumn.setResizable(true);
        dataTable.setSortColumn(vmNameColumn);
        dataTable.setSortDirection(128);
        this.dataTableViewer.setComparator(new ViewerComparator());
        this.dataTableViewer.setContentProvider((IContentProvider)new AbstractExecutionDataContentProvider(){

            public Object[] getElements(ExecutionDataContent content) {
                return content.getExecutionData();
            }
        });
        this.dataTableViewer.setInput((Object)this.content);
    }

    private void triggerRefresh() {
        this.refreshJob.cancel();
        this.refreshJob.schedule(250L);
    }

    private static abstract class AbstractExecutionDataColumnLabelProvider
    extends ColumnLabelProvider {
        private AbstractExecutionDataColumnLabelProvider() {
        }

        public final String getText(Object element) {
            return this.getText((ExecutionData)element);
        }

        public abstract String getText(ExecutionData var1);
    }

    private static class ClassIdLabelProvider
    extends AbstractExecutionDataColumnLabelProvider {
        private ClassIdLabelProvider() {
        }

        public String getText(ExecutionData element) {
            return String.format("0x%016x", element.getId());
        }

        public Font getFont(Object element) {
            return JFaceResources.getTextFont();
        }
    }

    private static class ExecutedProbesLabelProvider
    extends AbstractExecutionDataColumnLabelProvider {
        private ExecutedProbesLabelProvider() {
        }

        public String getText(ExecutionData element) {
            int executed = 0;
            boolean[] data = element.getProbes();
            int i = 0;
            while (i < data.length) {
                if (data[i]) {
                    ++executed;
                }
                ++i;
            }
            return Integer.toString(executed);
        }
    }

    private final class RefreshJob
    extends UIJob {
        public RefreshJob() {
            super(UIMessages.ExecutionDataEditorExecutedClassesPageRefreshing_task);
            this.setSystem(true);
            this.setPriority(20);
            this.setUser(false);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            ExecutedClassesPage.this.dataTableViewer.setFilters(new ViewerFilter[]{ExecutedClassesFilters.fromPatternString(ExecutedClassesPage.this.filter.getText().trim())});
            return Status.OK_STATUS;
        }
    }

    private static class TotalProbesLabelProvider
    extends AbstractExecutionDataColumnLabelProvider {
        private TotalProbesLabelProvider() {
        }

        public String getText(ExecutionData element) {
            return Integer.toString(element.getProbes().length);
        }
    }

    private static class VMNameLabelProvider
    extends AbstractExecutionDataColumnLabelProvider {
        private VMNameLabelProvider() {
        }

        public String getText(ExecutionData element) {
            return element.getName();
        }
    }
}

