/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.compat.internal;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.log.ILoggerProvider;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.tools.compat.internal.ClipboardServiceImpl;
import org.eclipse.e4.tools.compat.internal.DefaultLoggerProvider;
import org.eclipse.e4.tools.compat.internal.WorkbenchLogger;
import org.eclipse.e4.tools.services.IClipboardService;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.css.swt.theme.IThemeManager;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.services.AbstractServiceFactory;
import org.eclipse.ui.services.IServiceLocator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.w3c.dom.css.CSSStyleDeclaration;

public class ContextServiceFactory
extends AbstractServiceFactory {
    public Object create(Class serviceInterface, IServiceLocator parentLocator, IServiceLocator locator) {
        if (!IEclipseContext.class.equals((Object)serviceInterface)) {
            return null;
        }
        IWorkbenchLocationService wls = (IWorkbenchLocationService)locator.getService(IWorkbenchLocationService.class);
        IWorkbenchWindow window = wls.getWorkbenchWindow();
        IWorkbenchPartSite site = wls.getPartSite();
        Object o = parentLocator.getService(serviceInterface);
        if (window == null && site == null) {
            Bundle bundle = FrameworkUtil.getBundle(ContextServiceFactory.class);
            BundleContext bundleContext = bundle.getBundleContext();
            IEclipseContext serviceContext = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
            IEclipseContext appContext = serviceContext.createChild("WorkbenchContext");
            appContext.set(Display.class, (Object)Display.getCurrent());
            appContext.set(Logger.class, (Object)new WorkbenchLogger());
            appContext.set(IClipboardService.class, (Object)new ClipboardServiceImpl());
            appContext.set(Realm.class, (Object)Realm.getDefault());
            final Display d = Display.getCurrent();
            appContext.set(UISynchronize.class, (Object)new UISynchronize(){

                public void syncExec(Runnable runnable) {
                    d.syncExec(runnable);
                }

                public void asyncExec(Runnable runnable) {
                    d.asyncExec(runnable);
                }
            });
            IThemeManager manager = (IThemeManager)serviceContext.get(IThemeManager.class);
            final IThemeEngine engine = manager.getEngineForDisplay(Display.getCurrent());
            appContext.set(IThemeEngine.class, (Object)engine);
            appContext.set(IStylingEngine.class, (Object)new IStylingEngine(){

                public void setClassname(Object widget, String classname) {
                    ((Widget)widget).setData("org.eclipse.e4.ui.css.CssClassName", (Object)classname);
                    engine.applyStyles(widget, true);
                }

                public void setId(Object widget, String id) {
                    ((Widget)widget).setData("org.eclipse.e4.ui.css.id", (Object)id);
                    engine.applyStyles(widget, true);
                }

                public void style(Object widget) {
                    engine.applyStyles(widget, true);
                }

                public CSSStyleDeclaration getStyle(Object widget) {
                    return engine.getStyle(widget);
                }

                public void setClassnameAndId(Object widget, String classname, String id) {
                    ((Widget)widget).setData("org.eclipse.e4.ui.css.CssClassName", (Object)classname);
                    ((Widget)widget).setData("org.eclipse.e4.ui.css.id", (Object)id);
                    engine.applyStyles(widget, true);
                }
            });
            if (appContext.get(ILoggerProvider.class) == null) {
                appContext.set(ILoggerProvider.class, (Object)((ILoggerProvider)ContextInjectionFactory.make(DefaultLoggerProvider.class, (IEclipseContext)appContext)));
            }
            return appContext;
        }
        if (o != null && site == null) {
            final IEclipseContext windowContext = ((IEclipseContext)o).createChild("WindowContext(" + window + ")");
            windowContext.set(ISelectionService.class, (Object)window.getSelectionService());
            windowContext.declareModifiable("org.eclipse.ui.selection");
            window.getSelectionService().addSelectionListener(new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    if (!selection.isEmpty()) {
                        if (selection instanceof IStructuredSelection) {
                            IStructuredSelection s = (IStructuredSelection)selection;
                            if (s.size() == 1) {
                                windowContext.set("org.eclipse.ui.selection", s.getFirstElement());
                            } else {
                                windowContext.set("org.eclipse.ui.selection", (Object)s.toList());
                            }
                        } else {
                            windowContext.set("org.eclipse.ui.selection", (Object)selection);
                        }
                    }
                }
            });
            return windowContext;
        }
        return o;
    }
}

