/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.ast;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ruby.ast.IRubyASTVisitor;
import org.eclipse.dltk.ruby.ast.RubyASTUtil;

public class RubyModuleDeclaration
extends TypeDeclaration {
    private ASTNode name;

    public RubyModuleDeclaration(ASTNode name, Block body, int start, int end) {
        super(RubyASTUtil.resolveClassName(name), name.sourceStart(), name.sourceEnd(), start, end);
        this.name = name;
        this.fBody = body;
        this.setStart(start);
        this.setEnd(end);
    }

    public ASTNode getClassName() {
        return this.name;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((TypeDeclaration)this)) {
            if (this.name != null) {
                if (visitor instanceof IRubyASTVisitor) {
                    ((IRubyASTVisitor)visitor).visitTypeName(this.name);
                } else {
                    this.name.traverse(visitor);
                }
            }
            if (this.getBody() != null) {
                this.getBody().traverse(visitor);
            }
            visitor.endvisit((TypeDeclaration)this);
        }
    }

    public String resolveSuperClassReference(ASTNode node) {
        return RubyASTUtil.resolveClassName(node);
    }
}

