/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.index;

import java.util.Collection;
import java.util.List;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.rete.index.Indexer;
import org.eclipse.viatra.query.runtime.rete.index.IndexerListener;
import org.eclipse.viatra.query.runtime.rete.network.BaseNode;
import org.eclipse.viatra.query.runtime.rete.network.Direction;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.Supplier;
import org.eclipse.viatra.query.runtime.rete.traceability.TraceInfo;

public abstract class StandardIndexer
extends BaseNode
implements Indexer {
    protected Supplier parent = null;
    protected List<IndexerListener> listeners;
    protected TupleMask mask;

    public StandardIndexer(ReteContainer reteContainer, TupleMask mask) {
        super(reteContainer);
        this.mask = mask;
        this.listeners = CollectionsFactory.createObserverList();
    }

    protected void propagate(Direction direction, Tuple updateElement, Tuple signature, boolean change) {
        for (IndexerListener listener : this.listeners) {
            listener.notifyIndexerUpdate(direction, updateElement, signature, change);
        }
    }

    @Override
    public TupleMask getMask() {
        return this.mask;
    }

    @Override
    public Supplier getParent() {
        return this.parent;
    }

    @Override
    public void attachListener(IndexerListener listener) {
        this.listeners.add(0, listener);
        this.reteContainer.getTracker().registerDependency(this, listener.getOwner());
    }

    @Override
    public void detachListener(IndexerListener listener) {
        this.listeners.remove(listener);
        this.reteContainer.getTracker().unregisterDependency(this, listener.getOwner());
    }

    @Override
    public Collection<IndexerListener> getListeners() {
        return this.listeners;
    }

    @Override
    public ReteContainer getContainer() {
        return this.reteContainer;
    }

    @Override
    protected String toStringCore() {
        return String.valueOf(super.toStringCore()) + "(" + this.parent + "/" + this.mask + ")";
    }

    @Override
    public void assignTraceInfo(TraceInfo traceInfo) {
        super.assignTraceInfo(traceInfo);
        if (traceInfo.propagateFromIndexerToSupplierParent() && this.parent != null) {
            this.parent.acceptPropagatedTraceInfo(traceInfo);
        }
    }
}

