/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra.query.runtime.base.api.IStructuralFeatureInstanceProcessor;
import org.eclipse.viatra.query.runtime.base.core.AbstractBaseIndexStore;
import org.eclipse.viatra.query.runtime.base.core.NavigationHelperImpl;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.IMultiset;

public class EMFBaseIndexInstanceStore
extends AbstractBaseIndexStore {
    boolean isDirty = false;
    private Map<Object, FeatureData> featureDataMap = CollectionsFactory.createMap();
    private Map<Object, IMultiset<Object>> valueToFeatureMap = null;
    private final Map<Object, Set<EObject>> instanceMap = CollectionsFactory.createMap();
    private final Map<Object, IMultiset<Object>> dataTypeMap = CollectionsFactory.createMap();

    public EMFBaseIndexInstanceStore(NavigationHelperImpl navigationHelper, Logger logger) {
        super(navigationHelper, logger);
    }

    FeatureData getFeatureData(Object featureKey) {
        FeatureData data = this.featureDataMap.get(featureKey);
        if (data == null) {
            data = this.createFeatureData(featureKey);
            this.featureDataMap.put(featureKey, data);
        }
        return data;
    }

    private FeatureData createFeatureData(Object featureKey) {
        FeatureData data = new FeatureData();
        data.featureKey = featureKey;
        return data;
    }

    protected void insertFeatureTuple(Object featureKey, boolean unique, Object value, EObject holder) {
        boolean changed = this.getFeatureData(featureKey).insertFeatureTuple(unique, value, holder);
        if (changed) {
            if (this.valueToFeatureMap != null) {
                this.insertIntoValueToFeatureMap(featureKey, value);
            }
            this.isDirty = true;
            this.navigationHelper.notifyFeatureListeners(holder, featureKey, value, true);
        }
    }

    protected void removeFeatureTuple(Object featureKey, boolean unique, Object value, EObject holder) {
        boolean changed = this.getFeatureData(featureKey).removeFeatureTuple(unique, value, holder);
        if (changed) {
            if (this.valueToFeatureMap != null) {
                this.removeFromValueToFeatureMap(featureKey, value);
            }
            this.isDirty = true;
            this.navigationHelper.notifyFeatureListeners(holder, featureKey, value, false);
        }
    }

    public Set<Object> getFeatureKeysPointingTo(Object target) {
        IMultiset<Object> sources = this.getValueToFeatureMap().get(target);
        return sources == null ? Collections.emptySet() : sources.distinctValues();
    }

    private Map<Object, IMultiset<Object>> getValueToFeatureMap() {
        if (this.valueToFeatureMap == null) {
            this.valueToFeatureMap = CollectionsFactory.createMap();
            for (FeatureData featureData : this.featureDataMap.values()) {
                Object featureKey = featureData.getFeatureKey();
                featureData.forEach((source, target) -> this.insertIntoValueToFeatureMap(featureKey, target));
            }
        }
        return this.valueToFeatureMap;
    }

    private void insertIntoValueToFeatureMap(Object featureKey, Object target) {
        IMultiset featureKeys = this.valueToFeatureMap.computeIfAbsent(target, CollectionsFactory::emptyMultiset);
        featureKeys.addOne(featureKey);
    }

    private void removeFromValueToFeatureMap(Object featureKey, Object value) {
        IMultiset<Object> featureKeys = this.valueToFeatureMap.get(value);
        if (featureKeys == null) {
            throw new IllegalStateException();
        }
        featureKeys.removeOne(featureKey);
        if (featureKeys.isEmpty()) {
            this.valueToFeatureMap.remove(value);
        }
    }

    public Set<EObject> getInstanceSet(Object keyClass) {
        return this.instanceMap.get(keyClass);
    }

    public void removeInstanceSet(Object keyClass) {
        this.instanceMap.remove(keyClass);
    }

    public void insertIntoInstanceSet(Object keyClass, EObject value) {
        Set set = this.instanceMap.computeIfAbsent(keyClass, CollectionsFactory::emptySet);
        if (!set.add(value)) {
            String msg = String.format("Notification received to index %s as a %s, but it already exists in the index. This indicates some errors in underlying model representation.", value, keyClass);
            this.logNotificationHandlingError(msg);
        }
        this.isDirty = true;
        this.navigationHelper.notifyInstanceListeners(keyClass, value, true);
    }

    public void removeFromInstanceSet(Object keyClass, EObject value) {
        Set<EObject> set = this.instanceMap.get(keyClass);
        if (set != null) {
            if (!set.remove(value)) {
                String msg = String.format("Notification received to remove %s as a %s, but it is missing from the index. This indicates some errors in underlying model representation.", value, keyClass);
                this.logNotificationHandlingError(msg);
            }
            if (set.isEmpty()) {
                this.instanceMap.remove(keyClass);
            }
        }
        this.isDirty = true;
        this.navigationHelper.notifyInstanceListeners(keyClass, value, false);
    }

    public Set<Object> getDistinctDataTypeInstances(Object keyType) {
        IMultiset<Object> values = this.dataTypeMap.get(keyType);
        return values == null ? Collections.emptySet() : values.distinctValues();
    }

    public void removeDataTypeMap(Object keyType) {
        this.dataTypeMap.remove(keyType);
    }

    public void insertIntoDataTypeMap(Object keyType, Object value) {
        IMultiset valMap = this.dataTypeMap.computeIfAbsent(keyType, CollectionsFactory::emptyMultiset);
        boolean firstOccurrence = valMap.addOne(value);
        this.isDirty = true;
        this.navigationHelper.notifyDataTypeListeners(keyType, value, true, firstOccurrence);
    }

    public void removeFromDataTypeMap(Object keyType, Object value) {
        IMultiset<Object> valMap = this.dataTypeMap.get(keyType);
        if (valMap != null) {
            boolean lastOccurrence = valMap.removeOne(value);
            if (lastOccurrence && valMap.isEmpty()) {
                this.dataTypeMap.remove(keyType);
            }
            this.isDirty = true;
            this.navigationHelper.notifyDataTypeListeners(keyType, value, false, lastOccurrence);
        }
    }

    protected Set<EObject> getHoldersOfFeature(Object featureKey) {
        FeatureData featureData = this.getFeatureData(featureKey);
        return featureData.getAllDistinctHolders();
    }

    protected Set<Object> getValuesOfFeature(Object featureKey) {
        FeatureData featureData = this.getFeatureData(featureKey);
        return featureData.getAllDistinctValues();
    }

    public Set<EClass> getAllCurrentClasses() {
        Set result = CollectionsFactory.createSet();
        Set<Object> classifierKeys = this.instanceMap.keySet();
        for (Object classifierKey : classifierKeys) {
            EClassifier knownClassifier = this.navigationHelper.metaStore.getKnownClassifierForKey(classifierKey);
            if (!(knownClassifier instanceof EClass)) continue;
            result.add((EClass)knownClassifier);
        }
        return result;
    }

    Set<Object> getOldValuesForHolderAndFeature(EObject source, Object featureKey) {
        Map oldValuesToHolders = this.getFeatureData(featureKey).valueToHolderMap;
        HashSet<Object> oldValues = new HashSet<Object>();
        for (Map.Entry entry : oldValuesToHolders.entrySet()) {
            if (!((IMultiset)entry.getValue()).containsNonZero((Object)source)) continue;
            oldValues.add(entry.getKey());
        }
        return oldValues;
    }

    protected void forgetFeature(Object featureKey) {
        FeatureData removed = this.featureDataMap.remove(featureKey);
        if (this.valueToFeatureMap != null) {
            for (Object value : removed.getAllDistinctValues()) {
                this.removeFromValueToFeatureMap(featureKey, value);
            }
        }
    }

    class FeatureData {
        private Map<Object, IMultiset<EObject>> valueToHolderMap = CollectionsFactory.createMap();
        private Map<EObject, IMultiset<Object>> holderToValueMap;
        private Object featureKey;

        FeatureData() {
        }

        public Object getFeatureKey() {
            return this.featureKey;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + ":" + this.featureKey;
        }

        boolean insertFeatureTuple(boolean unique, Object value, EObject holder) {
            boolean changed = this.addToValueToHolderMap(value, holder);
            if (this.holderToValueMap != null) {
                this.addToHolderToValueMap(value, holder);
            }
            if (unique && !changed) {
                String msg = String.format("Error: trying to add duplicate value %s to the unique feature %s of host object %s. This indicates some errors in underlying model representation.", value, this.featureKey, holder);
                EMFBaseIndexInstanceStore.this.logNotificationHandlingError(msg);
            }
            return changed;
        }

        boolean removeFeatureTuple(boolean unique, Object value, EObject holder) {
            try {
                boolean changed = this.removeFromValueToHolderMap(value, holder);
                if (this.holderToValueMap != null) {
                    this.removeFromHolderToValueMap(value, holder);
                }
                if (unique && !changed) {
                    String msg = String.format("Error: trying to remove duplicate value %s from the unique feature %s of host object %s. This indicates some errors in underlying model representation.", value, this.featureKey, holder);
                    EMFBaseIndexInstanceStore.this.logNotificationHandlingError(msg);
                }
                return changed;
            }
            catch (IllegalStateException ex) {
                String msg = String.format("Error: trying to remove non-existing value %s from the feature %s of host object %s. This indicates some errors in underlying model representation.", value, this.featureKey, holder);
                EMFBaseIndexInstanceStore.this.logNotificationHandlingError(msg);
                return false;
            }
        }

        private boolean addToHolderToValueMap(Object value, EObject holder) {
            IMultiset values = this.holderToValueMap.computeIfAbsent(holder, CollectionsFactory::emptyMultiset);
            boolean changed = values.addOne(value);
            return changed;
        }

        private boolean addToValueToHolderMap(Object value, EObject holder) {
            IMultiset holders = this.valueToHolderMap.computeIfAbsent(value, CollectionsFactory::emptyMultiset);
            boolean changed = holders.addOne((Object)holder);
            return changed;
        }

        private boolean removeFromHolderToValueMap(Object value, EObject holder) throws IllegalStateException {
            IMultiset<Object> values = this.holderToValueMap.get(holder);
            if (values == null) {
                throw new IllegalStateException();
            }
            boolean changed = values.removeOne(value);
            if (changed && values.isEmpty()) {
                this.holderToValueMap.remove(holder);
            }
            return changed;
        }

        private boolean removeFromValueToHolderMap(Object value, EObject holder) throws IllegalStateException {
            IMultiset<EObject> holders = this.valueToHolderMap.get(value);
            if (holders == null) {
                throw new IllegalStateException();
            }
            boolean changed = holders.removeOne((Object)holder);
            if (changed && holders.isEmpty()) {
                this.valueToHolderMap.remove(value);
            }
            return changed;
        }

        private Map<EObject, IMultiset<Object>> getHolderToValueMap() {
            if (this.holderToValueMap == null) {
                this.holderToValueMap = CollectionsFactory.createMap();
                for (Map.Entry<Object, IMultiset<EObject>> entry : this.valueToHolderMap.entrySet()) {
                    Object value = entry.getKey();
                    IMultiset<EObject> holders = entry.getValue();
                    for (EObject holder : holders.distinctValues()) {
                        int count = holders.getCount((Object)holder);
                        IMultiset valuesOfHolder = this.holderToValueMap.computeIfAbsent(holder, CollectionsFactory::emptyMultiset);
                        valuesOfHolder.addPositive(value, count);
                    }
                }
            }
            return this.holderToValueMap;
        }

        private Map<Object, IMultiset<EObject>> getValueToHolderMap() {
            return this.valueToHolderMap;
        }

        public void forEach(IStructuralFeatureInstanceProcessor processor) {
            if (this.valueToHolderMap != null) {
                for (Map.Entry<Object, IMultiset<EObject>> entry : this.valueToHolderMap.entrySet()) {
                    Object value = entry.getKey();
                    for (EObject eObject : entry.getValue().distinctValues()) {
                        processor.process(eObject, value);
                    }
                }
            } else {
                throw new UnsupportedOperationException("TODO implement");
            }
        }

        public Set<EObject> getAllDistinctHolders() {
            return this.getHolderToValueMap().keySet();
        }

        public Set<Object> getAllDistinctValues() {
            return this.getValueToHolderMap().keySet();
        }

        public Set<EObject> getDistinctHoldersOfValue(Object value) {
            IMultiset<EObject> holdersMultiset = this.getValueToHolderMap().get(value);
            if (holdersMultiset == null) {
                return Collections.emptySet();
            }
            return holdersMultiset.distinctValues();
        }

        public Set<Object> getDistinctValuesOfHolder(EObject holder) {
            IMultiset<Object> valuesMultiset = this.getHolderToValueMap().get(holder);
            if (valuesMultiset == null) {
                return Collections.emptySet();
            }
            return valuesMultiset.distinctValues();
        }

        public boolean isInstance(EObject source, Object target) {
            if (this.valueToHolderMap != null) {
                IMultiset<EObject> holders = this.valueToHolderMap.get(target);
                return holders != null && holders.containsNonZero((Object)source);
            }
            throw new UnsupportedOperationException("TODO implement");
        }
    }
}

